﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>

namespace {

char g_Buffer[DefaultStackSize] __attribute__((aligned(0x1000)));

void TestThreadFunction0(uintptr_t arg)
{
    NN_UNUSED(arg);
    AutoThreadExit autoExit;
}

} // namespace



TEST(SignalEventTest, InvalidHandleTest)
{
    TestEventLeak leakTest;
    nn::Result result;
    nn::svc::Handle readHandle;
    nn::svc::Handle writeHandle;
    nn::svc::Handle threadHandle;

    // TEST 15-15
    result = nn::svc::SignalEvent(nn::svc::INVALID_HANDLE_VALUE);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 15-16
    result = nn::svc::SignalEvent(nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 15-17
    result = nn::svc::SignalEvent(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());


    // TEST 15-18
    result = nn::svc::CreateEvent(&writeHandle, &readHandle);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(writeHandle);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(readHandle);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SignalEvent(writeHandle);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 15-19
    uintptr_t pc;
    uintptr_t sp;

    pc = reinterpret_cast<uintptr_t>(TestThreadFunction0);
    sp = reinterpret_cast<uintptr_t>(g_Buffer + sizeof(g_Buffer));

    result = nn::svc::CreateThread(&threadHandle, pc, 0, sp,
            TestLowestThreadPriority, 0);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SignalEvent(threadHandle);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    result = nn::svc::CloseHandle(threadHandle);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SignalEvent(threadHandle);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());
}
