﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "test_SharedMemory.h"
#include <nn/nn_Assert.h>
#include <nn/svc/svc_Dd.h>
#include <nn/svc/svc_Dmnt.h>
#include <nn/svc/svc_Tcb.h>
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <cstring>
#include <nn/init.h>

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

namespace {

void SendAck(nn::svc::ipc::MessageBuffer& ipcMsg, nn::svc::Handle clientSession)
{
    nn::Result result;
    ipcMsg.SetNull();
    result = nn::svc::SendSyncRequest(clientSession);
    NN_ASSERT_RESULT_SUCCESS(result);
}

} // namespace

uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern "C" void nnMain()
{
    InitTestMemory();

    nn::Result result;
    nn::svc::Handle clientSession;
    nn::Bit32* pMsgBuffer;

    /*
       前準備
     */
    result = nn::svc::ConnectToNamedPort(&clientSession, PortName);
    NN_ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose cSessionCloser(clientSession);

    // IPC の設定
    pMsgBuffer = nn::svc::ipc::GetMessageBuffer();
    nn::svc::ipc::MessageBuffer ipcMsg(pMsgBuffer);


    // ハンドルを取得する
    const int HandleNum = 3;
    nn::svc::Handle handles[HandleNum];
    {
        ipcMsg.SetNull();
        SendAck(ipcMsg, clientSession);

        nn::svc::ipc::MessageBuffer::MessageHeader ipcHeader(ipcMsg);
        nn::svc::ipc::MessageBuffer::SpecialHeader ipcSpecial(ipcMsg, ipcHeader);
        NN_ASSERT(ipcHeader.GetSpecialNum() == 1);
        NN_ASSERT(ipcSpecial.GetMoveHandleNum() == HandleNum);
        int offset = ipcMsg.GetSpecialDataOffset(ipcHeader, ipcSpecial);
        for (int32_t i = 0; i < HandleNum; i++)
        {
            handles[i] = ipcMsg.GetHandle(offset + i);
        }
    }

    // DontCare

    // TEST 17-47
    // MemoryPermission_ReadWrite を指定することが出来る
    result = nn::svc::MapSharedMemory(
                handles[0], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_ReadWrite);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::UnmapSharedMemory(handles[0], g_FreeAreaBegin, SharedSize);
    NN_ASSERT_RESULT_SUCCESS(result);

    // TEST 17-48
    // MemoryPermission_Read を指定することが出来る
    result = nn::svc::MapSharedMemory(
                handles[0], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_Read);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::UnmapSharedMemory(handles[0], g_FreeAreaBegin, SharedSize);
    NN_ASSERT_RESULT_SUCCESS(result);

    // TEST 17-49
    // MemoryPermission_Write を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[0], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_Write);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-50
    // MemoryPermission_ReadExecute を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[0], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_ReadExecute);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-51
    // MemoryPermission_None を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[0], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_None);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-52
    // MemoryPermission_Execute を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[0], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_Execute);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // ReadWrite

    // TEST 17-55
    // MemoryPermission_ReadWrite を指定することが出来る
    result = nn::svc::MapSharedMemory(
                handles[1], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_ReadWrite);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::UnmapSharedMemory(handles[1], g_FreeAreaBegin, SharedSize);
    NN_ASSERT_RESULT_SUCCESS(result);

    // TEST 17-56
    // MemoryPermission_Read を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[1], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_Read);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-57
    // MemoryPermission_Write を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[1], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_Write);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-58
    // MemoryPermission_ReadExecute を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[1], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_ReadExecute);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-59
    // MemoryPermission_None を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[1], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_None);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-60
    // MemoryPermission_Execute を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[1], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_Execute);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // Read

    // TEST 17-61
    // MemoryPermission_ReadWrite を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[2], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_ReadWrite);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-62
    // MemoryPermission_Read を指定することが出来る
    result = nn::svc::MapSharedMemory(
                handles[2], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_Read);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::UnmapSharedMemory(handles[2], g_FreeAreaBegin, SharedSize);
    NN_ASSERT_RESULT_SUCCESS(result);

    // TEST 17-63
    // MemoryPermission_Write を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[2], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_Write);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-64
    // MemoryPermission_ReadExecute を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[2], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_ReadExecute);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-65
    // MemoryPermission_None を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[2], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_None);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // TEST 17-66
    // MemoryPermission_Execute を指定することが出来ない
    result = nn::svc::MapSharedMemory(
                handles[2], g_FreeAreaBegin, SharedSize, nn::svc::MemoryPermission_Execute);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidNewMemoryPermission());

    // 終了処理
    for (int32_t i = 0; i < HandleNum; i++)
    {
        result = nn::svc::CloseHandle(handles[i]);
        NN_ASSERT_RESULT_SUCCESS(result);
    }

    // 最後にテストが終了したことを通知する
    SendAck(ipcMsg, clientSession);
}

