﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"

extern nn::Result ClientSendLightRequest(nn::svc::Handle handle);
extern nn::Result ServerReceiveLightRequest(nn::svc::Handle handle);
extern nn::Result ServerReplyLightRequest(nn::svc::Handle handle);

namespace {
} // namespace

TEST(SendSyncRequestLight, HandleTest)
{
    TestLightSessionLeak leakTest;
    nn::Result result;
    nn::svc::Handle serverPort;
    nn::svc::Handle clientPort;
    nn::svc::Handle serverSession;
    nn::svc::Handle clientSession;
    int32_t index;

    // TEST 27-7
    // INVALID_HANDLE_VALUE を受け付けない
    result = ClientSendLightRequest(nn::svc::INVALID_HANDLE_VALUE);
    ASSERT_RESULT_FAILURE(result);

    // TEST 27-8
    // スレッドの擬似ハンドルは受け付けない
    result = ClientSendLightRequest(nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_FAILURE(result);

    // TEST 27-9
    // プロセスの擬似ハンドルは受け付けない
    result = ClientSendLightRequest(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE(result);


    // TEST 27-10
    // NamedPort の Normal Session は受け付けない
    {
        const char* portName = "lightTest";
        result = nn::svc::ManageNamedPort(&serverPort, portName, 1);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sPortCloser(serverPort);

        result = nn::svc::ConnectToNamedPort(&clientSession, portName);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose cSessionCloser(clientSession);

        result = nn::svc::WaitSynchronization(&index, &serverPort, 1, 0);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::AcceptSession(&serverSession, serverPort);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sSessionCloser(serverSession);

        result = ClientSendLightRequest(serverPort);
        ASSERT_RESULT_FAILURE(result);

        result = ClientSendLightRequest(clientSession);
        ASSERT_RESULT_FAILURE(result);

        result = ClientSendLightRequest(serverSession);
        ASSERT_RESULT_FAILURE(result);

        result = nn::svc::ManageNamedPort(&serverPort, portName, 0);
        ASSERT_RESULT_SUCCESS(result);
    }

    // TEST 27-11
    // Port の Normal Session は受け付けない
    {
        result = nn::svc::CreatePort(&serverPort, &clientPort, 1, false, 1);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sPortCloser(serverPort);
        AutoHandleClose cPortCloser(clientPort);

        result = nn::svc::ConnectToPort(&clientSession, clientPort);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose cSessionCloser(clientSession);

        result = nn::svc::WaitSynchronization(&index, &serverPort, 1, 0);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::AcceptSession(&serverSession, serverPort);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sSessionCloser(serverSession);

        result = ClientSendLightRequest(serverPort);
        ASSERT_RESULT_FAILURE(result);

        result = ClientSendLightRequest(clientPort);
        ASSERT_RESULT_FAILURE(result);

        result = ClientSendLightRequest(clientSession);
        ASSERT_RESULT_FAILURE(result);

        result = ClientSendLightRequest(serverSession);
        ASSERT_RESULT_FAILURE(result);
    }

    // TEST 27-12
    // Session の Normal Session は受け付けない
    {
        result = nn::svc::CreateSession(&serverSession, &clientSession, false, 1);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sSessionCloser(serverSession);
        AutoHandleClose cSessionCloser(clientSession);

        result = ClientSendLightRequest(clientSession);
        ASSERT_RESULT_FAILURE(result);

        result = ClientSendLightRequest(serverSession);
        ASSERT_RESULT_FAILURE(result);
    }

    {
        result = nn::svc::CreateSession(&serverSession, &clientSession, true, 1);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sSessionCloser(serverSession);
        AutoHandleClose cSessionCloser(clientSession);

        // TEST 27-14
        // サーバーセッションは受け付けない
        result = ClientSendLightRequest(serverSession);
        ASSERT_RESULT_FAILURE(result);

        result = cSessionCloser.Close();
        ASSERT_RESULT_SUCCESS(result);

        // TEST 27-13
        // 閉じられたセッションは受け付けない
        result = ClientSendLightRequest(clientSession);
        ASSERT_RESULT_FAILURE(result);
    }
}

