﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Compiler.h>
#include "test_Common.h"

namespace {
const char* testString = "test";
}
extern "C" void nnMain();

#if defined NN_BUILD_CONFIG_COMPILER_CLANG
#pragma clang diagnostic ignored "-Wtautological-compare"
#endif

TEST(QueryMemory, NormalTest)
{
    uintptr_t addr;
    uintptr_t v;
    size_t size;
    nn::Result result;
    int i;
    nn::svc::MemoryInfo blockInfo;
    nn::svc::PageInfo pageInfo;

    size = HeapAlign;
    result = nn::svc::SetHeapSize(&addr, size);
    ASSERT_RESULT_SUCCESS(result);

    // 全アドレス空間を4Kごとにチェック
    v = CheckVirtualBegin;
    do
    {
        result = nn::svc::QueryMemory(&blockInfo, &pageInfo, v);
        if (ProcessBegin <= v && v <= ProcessEnd)
        {
            ASSERT_RESULT_SUCCESS(result);
            if (blockInfo.baseAddress <= reinterpret_cast<uintptr_t>(&nnMain) && reinterpret_cast<uintptr_t>(&nnMain) <= blockInfo.baseAddress + blockInfo.size - 1)
            {
                ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadExecute);
                ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);
            }
            else if (blockInfo.baseAddress <= reinterpret_cast<uintptr_t>(testString) && reinterpret_cast<uintptr_t>(testString) <= blockInfo.baseAddress + blockInfo.size - 1)
            {
                ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_Read);
                ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Code);
            }
            else if (blockInfo.baseAddress <= reinterpret_cast<uintptr_t>(&i) && reinterpret_cast<uintptr_t>(&i) <= blockInfo.baseAddress + blockInfo.size - 1)
            {
                ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);
                ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Stack || blockInfo.state == nn::svc::MemoryState_Normal);
            }
            else if (blockInfo.baseAddress <= addr && addr <= blockInfo.baseAddress + blockInfo.size - 1)
            {
                ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);
                ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Normal);
            }
        }
        else
        {
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(blockInfo.baseAddress == ProcessEnd + 1);
            ASSERT_TRUE(blockInfo.size == (0 - (ProcessEnd + ProcessBegin + 1)));
            ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Inaccessible);
            ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_None);
        }
        v += 0x1000;
    } while (v != CheckVirtualEnd);

    result = nn::svc::SetHeapSize(&addr, 0);
    ASSERT_RESULT_SUCCESS(result);
}

