﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>
#include <cstring>
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <nn/util/util_BitPack.h>
#include <nn/nn_BitTypes.h>
#include <nn/os.h>
#include <nn/svc/svc_Tcb.h>
#include <nn/svc/svc_BaseId.autogen.h>
#include <nn/svc/svc_ServerId.autogen.h>

#if defined NN_BUILD_CONFIG_CPU_ARM
#define SEND_SYNC_REQUEST_LIGHT(\
        result, out0, out1, out2, out3, out4, out5, out6,\
        session, in0, in1, in2, in3, in4, in5, in6) \
do \
{ \
    register nn::Bit32 __r0 asm ("r0") = static_cast<nnHandle>(session).value; \
    register nn::Bit32 __r1 asm ("r1") = (in0); \
    register nn::Bit32 __r2 asm ("r2") = (in1); \
    register nn::Bit32 __r3 asm ("r3") = (in2); \
    register nn::Bit32 __r4 asm ("r4") = (in3); \
    register nn::Bit32 __r5 asm ("r5") = (in4); \
    register nn::Bit32 __r6 asm ("r6") = (in5); \
    register nn::Bit32 __r7 asm ("r7") = (in6); \
    asm volatile ("svc %8" \
            :"+r"(__r0), "+r"(__r1), "+r"(__r2), "+r"(__r3), "+r"(__r4), "+r"(__r5), "+r"(__r6), "+r"(__r7) \
            :"I"(NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT) \
            :"memory","cc", "r12");    \
    result = nn::result::detail::ConstructResult(__r0); \
    (out0) = __r1; \
    (out1) = __r2; \
    (out2) = __r3; \
    (out3) = __r4; \
    (out4) = __r5; \
    (out5) = __r6; \
    (out6) = __r7; \
} while (false)

#define REPLY_AND_RECEIVE_LIGHT(\
        result, out0, out1, out2, out3, out4, out5, out6,\
        session, in0, in1, in2, in3, in4, in5, in6) \
do \
{ \
    register nn::Bit32 __r0 asm ("r0") = static_cast<nnHandle>(session).value; \
    register nn::Bit32 __r1 asm ("r1") = (in0); \
    register nn::Bit32 __r2 asm ("r2") = (in1); \
    register nn::Bit32 __r3 asm ("r3") = (in2); \
    register nn::Bit32 __r4 asm ("r4") = (in3); \
    register nn::Bit32 __r5 asm ("r5") = (in4); \
    register nn::Bit32 __r6 asm ("r6") = (in5); \
    register nn::Bit32 __r7 asm ("r7") = (in6); \
    asm volatile ("svc %8" \
            :"+r"(__r0), "+r"(__r1), "+r"(__r2), "+r"(__r3), "+r"(__r4), "+r"(__r5), "+r"(__r6), "+r"(__r7) \
            :"I"(NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT) \
            :"memory","cc", "r12");    \
    result = nn::result::detail::ConstructResult(__r0); \
    (out0) = __r1; \
    (out1) = __r2; \
    (out2) = __r3; \
    (out3) = __r4; \
    (out4) = __r5; \
    (out5) = __r6; \
    (out6) = __r7; \
} while (false)

#elif defined NN_BUILD_CONFIG_CPU_ARM64
#define SEND_SYNC_REQUEST_LIGHT(\
        result, out0, out1, out2, out3, out4, out5, out6,\
        session, in0, in1, in2, in3, in4, in5, in6) \
do \
{ \
    register nn::Bit32 __r0 asm ("w0") = static_cast<nnHandle>(session).value; \
    register nn::Bit32 __r1 asm ("w1") = (in0); \
    register nn::Bit32 __r2 asm ("w2") = (in1); \
    register nn::Bit32 __r3 asm ("w3") = (in2); \
    register nn::Bit32 __r4 asm ("w4") = (in3); \
    register nn::Bit32 __r5 asm ("w5") = (in4); \
    register nn::Bit32 __r6 asm ("w6") = (in5); \
    register nn::Bit32 __r7 asm ("w7") = (in6); \
    asm volatile ("svc %8" \
            :"+r"(__r0), "+r"(__r1), "+r"(__r2), "+r"(__r3), "+r"(__r4), "+r"(__r5), "+r"(__r6), "+r"(__r7) \
            :"I"(NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT) \
            :"memory","cc", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x18");    \
    result = nn::result::detail::ConstructResult(__r0); \
    (out0) = __r1; \
    (out1) = __r2; \
    (out2) = __r3; \
    (out3) = __r4; \
    (out4) = __r5; \
    (out5) = __r6; \
    (out6) = __r7; \
} while (false)

#define REPLY_AND_RECEIVE_LIGHT(\
        result, out0, out1, out2, out3, out4, out5, out6,\
        session, in0, in1, in2, in3, in4, in5, in6) \
do \
{ \
    register nn::Bit32 __r0 asm ("w0") = static_cast<nnHandle>(session).value; \
    register nn::Bit32 __r1 asm ("w1") = (in0); \
    register nn::Bit32 __r2 asm ("w2") = (in1); \
    register nn::Bit32 __r3 asm ("w3") = (in2); \
    register nn::Bit32 __r4 asm ("w4") = (in3); \
    register nn::Bit32 __r5 asm ("w5") = (in4); \
    register nn::Bit32 __r6 asm ("w6") = (in5); \
    register nn::Bit32 __r7 asm ("w7") = (in6); \
    asm volatile ("svc %8" \
            :"+r"(__r0), "+r"(__r1), "+r"(__r2), "+r"(__r3), "+r"(__r4), "+r"(__r5), "+r"(__r6), "+r"(__r7) \
            :"I"(NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT) \
            :"memory","cc", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x18");    \
    result = nn::result::detail::ConstructResult(__r0); \
    (out0) = __r1; \
    (out1) = __r2; \
    (out2) = __r3; \
    (out3) = __r4; \
    (out4) = __r5; \
    (out5) = __r6; \
    (out6) = __r7; \
} while (false)

#endif

namespace {
char g_Buffer[0x8000] __attribute__((aligned(0x1000)));
struct TestData
{
    nn::svc::Handle serverSession;
};

void LightIpcThread(TestData* pData)
{
    AutoThreadExit autoExit;
    nn::Result result;

    nn::Bit32 arg[7] = {1, 2, 3, 4, 5, 6, 7};

    REPLY_AND_RECEIVE_LIGHT(
            result,
            arg[0], arg[1], arg[2], arg[3], arg[4], arg[5], arg[6],
            pData->serverSession,
            arg[0], arg[1], arg[2], arg[3], arg[4], arg[5], arg[6]);
    NN_ABORT_UNLESS(result <= nn::svc::ResultCancelled());
    nn::svc::CloseHandle(pData->serverSession);
}

}

TEST(ReplyAndReceiveLightCancel, Test0)
{
    int32_t index;
    nn::svc::Handle handle;
    nn::svc::Handle serverSession0;
    nn::svc::Handle clientSession0;
    TestData data;
    nn::Result result;

    TestLightSessionLeak leakTest;
    result = nn::svc::CreateSession(&serverSession0, &clientSession0, true, 0);
    NN_ABORT_UNLESS(result.IsSuccess());

    data.serverSession = serverSession0;
    uintptr_t sp = reinterpret_cast<uintptr_t>(g_Buffer + sizeof(g_Buffer));
    uintptr_t pc = reinterpret_cast<uintptr_t>(LightIpcThread);
    nn::svc::CreateThread(&handle, pc, reinterpret_cast<uintptr_t>(&data), sp, 32, 0);
    nn::svc::StartThread(handle);

    nn::svc::SleepThread(1000 * 1000 * 1000);

    result = nn::svc::CancelSynchronization(handle);
    ASSERT_RESULT_SUCCESS(result);

    nn::svc::WaitSynchronization(&index, &handle, 1, -1);
    nn::svc::CloseHandle(handle);
    nn::svc::CloseHandle(clientSession0);
}

