﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"

TEST(GetSystemTick, MoreThanInt32)
{
    int64_t t0 = nn::svc::GetSystemTick();

    // TEST 25-4
    // 0x7FFFFFFF よりも大きな値を取得できること
    while (UINT32_MAX > t0)
    {
        t0 = nn::svc::GetSystemTick();
        ASSERT_TRUE(t0 >= 0);
    }
    // UINT32_MAX と同じ値になっている可能性があるので、もう一度取得しておく
    t0 = nn::svc::GetSystemTick();
    ASSERT_TRUE(t0 > UINT32_MAX);
}

