﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"

namespace {
char g_Buffer[DefaultStackSize] __attribute__((aligned(0x1000)));
int64_t g_SavedTick;

const int NumTest = 10000;
struct TestData
{
    nn::svc::Handle writableEvent;
    nn::svc::Handle readableEvent;
};

void TestGetSystemTick(TestData* pData)
{
    AutoThreadExit autoExit;

    for (int i = 0; i < NumTest; i++)
    {
        nn::Result result;
        int32_t index;

        result = nn::svc::WaitSynchronization(&index, &pData->readableEvent, 1, -1);
        ASSERT_RESULT_SUCCESS(result);
        ASSERT_TRUE(index == 0);
        result = nn::svc::ResetSignal(pData->readableEvent);
        ASSERT_RESULT_SUCCESS(result);

        ASSERT_TRUE(g_SavedTick < nn::svc::GetSystemTick());
        g_SavedTick = 0x7fffffffffffffffll;

        result = nn::svc::SignalEvent(pData->writableEvent);
        ASSERT_RESULT_SUCCESS(result);
    }
}
}

TEST(GetSystemTick, Test0)
{
    int64_t t0 = nn::svc::GetSystemTick();

    // TEST 25-1
    // 取得する値が前回取得した値よりも大きいことを確認する
    for (int i = 0; i < NumTest; i++)
    {
        int64_t tmp;
        tmp = nn::svc::GetSystemTick();
        ASSERT_TRUE(t0 < tmp);
        t0 = tmp;
    }
}


TEST(GetSystemTick, Test1)
{
    nn::Result result;
    nn::svc::Handle writableEvent0;
    nn::svc::Handle readableEvent0;
    result = nn::svc::CreateEvent(&writableEvent0, &readableEvent0);
    ASSERT_RESULT_SUCCESS(result);
    nn::svc::Handle writableEvent1;
    nn::svc::Handle readableEvent1;
    result = nn::svc::CreateEvent(&writableEvent1, &readableEvent1);
    ASSERT_RESULT_SUCCESS(result);
    TestData data;
    data.readableEvent = readableEvent0;
    data.writableEvent = writableEvent1;

    // TEST 25-2 (同じコア), 25-3 (別のコア)
    // スレッドが異なっていても、呼び出す毎に取得する値が大きくなることを確認
    for (int32_t idealCore = 0; idealCore < NumCore; idealCore++)
    {
        uintptr_t sp = reinterpret_cast<uintptr_t>(g_Buffer + sizeof(g_Buffer));
        uintptr_t pc = reinterpret_cast<uintptr_t>(TestGetSystemTick);
        nn::svc::Handle handle;

        result = nn::svc::CreateThread(&handle, pc, reinterpret_cast<uintptr_t>(&data), sp, 32, idealCore);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::StartThread(handle);
        ASSERT_RESULT_SUCCESS(result);

        for (int i = 0; i < NumTest; i++)
        {
            g_SavedTick = nn::svc::GetSystemTick();
            result = nn::svc::SignalEvent(writableEvent0);
            ASSERT_RESULT_SUCCESS(result);
            int32_t index;

            result = nn::svc::WaitSynchronization(&index, &readableEvent1, 1, -1);
            ASSERT_RESULT_SUCCESS(result);
            ASSERT_TRUE(index == 0);
            result = nn::svc::ResetSignal(readableEvent1);
            ASSERT_RESULT_SUCCESS(result);
        }

        int32_t index;
        result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::CloseHandle(handle);
        ASSERT_RESULT_SUCCESS(result);
    }
    result = nn::svc::CloseHandle(writableEvent0);
    result = nn::svc::CloseHandle(readableEvent0);
    result = nn::svc::CloseHandle(writableEvent1);
    result = nn::svc::CloseHandle(readableEvent1);
}

