﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"

namespace {

#ifdef INVALID_POINTER_TEST
const int tmpVar = 0;
#endif

void CheckAddressPermission(uintptr_t addr, nn::svc::MemoryPermission permission)
{
    nn::svc::MemoryInfo blockInfo;
    nn::svc::PageInfo pageInfo;
    nn::Result result;

    result = nn::svc::QueryMemory(&blockInfo, &pageInfo, addr);
    ASSERT_RESULT_SUCCESS(result);

    ASSERT_TRUE(blockInfo.permission == permission);
}

} // namespace

extern "C" void nnMain();

TEST(GetProcessId, InvalidHandleTest)
{
    TestProcessLeak leakTest;
    nn::Result result;
    nn::Bit64 pid;

    // TEST 31-5
    // INVALID_HANDLE_VALUE を渡すと失敗する
    result = nn::svc::GetProcessId(&pid, nn::svc::INVALID_HANDLE_VALUE);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());
}

TEST(GetProcessId, MemoryPermissionTest)
{
    TestProcessLeak leakTest;
    nn::Result result;
    nn::Bit64 pid;
    uintptr_t addr;

#ifdef INVALID_POINTER_TEST
    // TEST 31-6
    // NULL を与えると失敗する
    result = nn::svc::GetProcessId(NULL, nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 31-8
    // MemoryPermission_None の領域を指定すると失敗する
    addr = g_FreeAreaBegin;
    CheckAddressPermission(addr, nn::svc::MemoryPermission_None);
    result = nn::svc::GetProcessId(
            reinterpret_cast<nn::Bit64*>(addr), nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 31-9
    // MemoryPermission_Read の領域を指定すると失敗する
    addr = reinterpret_cast<uintptr_t>(&tmpVar);
    CheckAddressPermission(addr, nn::svc::MemoryPermission_Read);
    result = nn::svc::GetProcessId(
            reinterpret_cast<nn::Bit64*>(addr), nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 31-10
    // MemoryPermission_ReadExecute の領域を指定すると失敗する
    addr = reinterpret_cast<uintptr_t>(nnMain);
    CheckAddressPermission(addr, nn::svc::MemoryPermission_ReadExecute);
    result = nn::svc::GetProcessId(
            reinterpret_cast<nn::Bit64*>(addr), nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

    // TEST 31-11
    // MemoryPermission_ReadWrite の領域を指定すると成功する
    addr = reinterpret_cast<uintptr_t>(&pid);
    CheckAddressPermission(addr, nn::svc::MemoryPermission_ReadWrite);
    result = nn::svc::GetProcessId(
            reinterpret_cast<nn::Bit64*>(addr), nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_SUCCESS(result);
}

