﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "util_TestLoader.h"

extern char BinExitProcess_begin[];
extern char BinExitProcess_end[];

TEST(ExitProcess, Test0)
{
    nn::Result result;

    uintptr_t begin = reinterpret_cast<uintptr_t>(BinExitProcess_begin);
    uintptr_t end = reinterpret_cast<uintptr_t>(BinExitProcess_end);
    TestLoader loader(BinExitProcess_begin, end - begin);

    nn::svc::Handle clientProcess;
    loader.SpawnProcess(&clientProcess);
    loader.StartProcess(clientProcess);
    AutoHandleClose processCloser(clientProcess);

    WaitProcess(clientProcess);
}

