﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "util_TestSdmmc.h"
#include <nn/svc/svc_Dd.h>

#ifdef SUPPORT_SDCARD_TEST

namespace {

const uint64_t SpaceAddr = 0x0;
} // namespace

// TEST 131-9
// ハンドルと紐づいていないデバイス名を指定できない
TEST(DetachDeviceAddressSpace, InvalidStateTest)
{
    TestDeviceAddressSpaceLeak leakTest;
    nn::Result result;
    uint64_t size = 0x80000000;
    nn::svc::Handle handles[2];

    result = nn::svc::CreateDeviceAddressSpace(&handles[0], SpaceAddr, size);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose addressCloser1(handles[0]);

    result = nn::svc::CreateDeviceAddressSpace(&handles[1], SpaceAddr, size);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose addressCloser2(handles[1]);

    result = nn::svc::AttachDeviceAddressSpace(DeviceName_SdCard, handles[0]);
    ASSERT_RESULT_SUCCESS(result);

#ifdef SUPPORT_MMC_TEST
    result = nn::svc::AttachDeviceAddressSpace(DeviceName_Mmc, handles[1]);
    ASSERT_RESULT_SUCCESS(result);
#endif // SUPPORT_MMC_TEST

    result = nn::svc::DetachDeviceAddressSpace(DeviceName_SdCard, handles[1]);
    ASSERT_RESULT_FAILURE(result);

#ifdef SUPPORT_MMC_TEST
    result = nn::svc::DetachDeviceAddressSpace(DeviceName_Mmc, handles[0]);
    ASSERT_RESULT_FAILURE(result);
#endif // SUPPORT_MMC_TEST

    result = nn::svc::DetachDeviceAddressSpace(DeviceName_SdCard, handles[0]);
    ASSERT_RESULT_SUCCESS(result);

#ifdef SUPPORT_MMC_TEST
    result = nn::svc::DetachDeviceAddressSpace(DeviceName_Mmc, handles[1]);
    ASSERT_RESULT_SUCCESS(result);
#endif // SUPPORT_MMC_TEST

}

#endif // SUPPORT_SDCARD_TEST

