﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "util_TestSdmmc.h"
#include <nn/svc/svc_Dd.h>

namespace {

const uint64_t SpaceAddr = 0x0;
} // namespace

TEST(DetachDeviceAddressSpace, DeviceNameTest)
{
    TestDeviceAddressSpaceLeak leakTest;
    nn::Result result;
    uint64_t size = 0x80000000;
    nn::svc::Handle handle;

    result = nn::svc::CreateDeviceAddressSpace(&handle, SpaceAddr, size);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose addressCloser(handle);

    // TEST 131-1
    // 既定のデバイス名を指定することが出来る
    // test_AttachDeviceAddressSpace_Arguments.cpp で実施

    // TEST 131-2
    // アタッチしていないデバイス名を指定することは出来ない
    for (int32_t i = 0; i < nn::svc::DeviceName_Num; i++)
    {
        nn::svc::DeviceName name = static_cast<nn::svc::DeviceName>(i);
        result = nn::svc::DetachDeviceAddressSpace(name, handle);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidState());
    }
}

TEST(DetachDeviceAddressSpace, HandleTest)
{
    TestDeviceAddressSpaceLeak leakTest;
    nn::Result result;
    uint64_t size = 0x80000000;
    nn::svc::Handle handle;
    nn::svc::DeviceName name = DeviceName_SdCard;

    result = nn::svc::CreateDeviceAddressSpace(&handle, SpaceAddr, size);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose addressCloser(handle);

#ifdef SUPPORT_SDCARD_TEST
    result = nn::svc::AttachDeviceAddressSpace(name, handle);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 131-3
    // CreateDeviceAddressSpace のハンドルを受け付ける
    // test_AttachDeviceAddressSpace_Arguments.cpp で実施

    // TEST 131-4
    // INVALID_HANDLE_VALUE　を受け付けない
    result = nn::svc::DetachDeviceAddressSpace(name, nn::svc::INVALID_HANDLE_VALUE);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 131-5
    // スレッドの擬似ハンドルを受け付けない
    result = nn::svc::DetachDeviceAddressSpace(name, nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    // TEST 131-6
    // プロセスの擬似ハンドルを受け付けない
    result = nn::svc::DetachDeviceAddressSpace(name, nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());

    result = nn::svc::DetachDeviceAddressSpace(name, handle);
    ASSERT_RESULT_SUCCESS(result);
#endif // SUPPORT_SDCARD_TEST

    // TEST 131-8
    // Attach していないハンドラを受け付けない
    result = nn::svc::DetachDeviceAddressSpace(name, handle);
    ASSERT_TRUE(result <= nn::svc::ResultInvalidState() ||
                result <= nn::svc::ResultInvalidHandle());

    // TEST 131-7
    // Close したハンドラを受け付けない
    result = nn::svc::CloseHandle(handle);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::DetachDeviceAddressSpace(name, handle);
    ASSERT_TRUE(result <= nn::svc::ResultInvalidState() ||
                result <= nn::svc::ResultInvalidHandle());
}

