﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Dd.h>

namespace {

extern "C" void nnMain();

} // namespace

#ifdef INVALID_POINTER_TEST
TEST(CreateSharedMemory, InvalidPointerTest)
{
    TestSharedMemoryLeak leakTest;
    nn::Result result;
    nn::svc::MemoryPermission myPermission = nn::svc::MemoryPermission_ReadWrite;
    nn::svc::MemoryPermission otherPermission = nn::svc::MemoryPermission_ReadWrite;
    size_t size = 0x1000;
    nn::svc::Handle* handle;

#ifdef INVALID_POINTER_TEST
    // TEST 80-2
    // NULL アドレスは受け付けない
    result = nn::svc::CreateSharedMemory(NULL, size, myPermission, otherPermission);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 80-3
    // MemoryPermission_None の領域を渡すと失敗する
    handle = reinterpret_cast<nn::svc::Handle*>(g_FreeAreaBegin);
    result = nn::svc::CreateSharedMemory(handle, size, myPermission, otherPermission);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 80-4
    // MemoryPermission_Read の領域を渡すと失敗する
    {
        TestHeap heap(HeapAlign);
        {
            TestMemoryPermission perm(heap.GetAddress(), size, nn::svc::MemoryPermission_Read);
            handle = reinterpret_cast<nn::svc::Handle*>(heap.GetAddress());
            result = nn::svc::CreateSharedMemory(handle, size, myPermission, otherPermission);
            ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
        }
    }
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 80-5
    // MemoryPermission_ReadExecute の領域を渡すと失敗する
    handle = reinterpret_cast<nn::svc::Handle*>(nnMain);
    result = nn::svc::CreateSharedMemory(handle, size, myPermission, otherPermission);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

}
#endif // INVALID_POINTER_TEST

TEST(CreateSharedMemory, SizeTest)
{
    TestSharedMemoryLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
    nn::svc::MemoryPermission myPermission = nn::svc::MemoryPermission_ReadWrite;
    nn::svc::MemoryPermission otherPermission = nn::svc::MemoryPermission_ReadWrite;

    // TEST 80-8
    // 0 は受け付けない
    result = nn::svc::CreateSharedMemory(&handle, 0, myPermission, otherPermission);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidSize());

    // TEST 80-9
    // 4 KB にアライメントされていないと失敗する
    for (size_t invalidSize = 1; invalidSize < 0x1000; invalidSize++)
    {
        result = nn::svc::CreateSharedMemory(&handle, invalidSize, myPermission, otherPermission);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidSize());
    }
}

