﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>

TEST(CreateEventTest, NormalCaseTest)
{
    TestEventLeak leakTest;
    nn::Result result;
    nn::svc::Handle writeHandle;
    nn::svc::Handle readHandle;

    // TEST 69-1
    result = nn::svc::CreateEvent(&writeHandle, &readHandle);
    ASSERT_RESULT_SUCCESS(result);

    ASSERT_TRUE(writeHandle.IsValid());
    ASSERT_TRUE(readHandle.IsValid());

    // TEST 69-10
    result = nn::svc::CloseHandle(writeHandle);
    ASSERT_RESULT_SUCCESS(result);

    // TEST 69-11
    result = nn::svc::CloseHandle(readHandle);
    ASSERT_RESULT_SUCCESS(result);

}

