﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>

namespace {

#ifdef INVALID_POINTER_TEST
const int TmpVar = 0;
const char* PortName = "NamedPort";
#endif

#ifdef INVALID_POINTER_TEST
void CheckAddressPermission(uintptr_t addr, nn::svc::MemoryPermission permission)
{
    nn::svc::MemoryInfo blockInfo;
    nn::svc::PageInfo pageInfo;
    nn::Result result;

    result = nn::svc::QueryMemory(&blockInfo, &pageInfo, addr);
    ASSERT_RESULT_SUCCESS(result);

    ASSERT_TRUE(blockInfo.permission == permission);
}
#endif // INVALID_POINTER_TEST

} //namespace

extern "C" void nnMain();

#ifdef INVALID_POINTER_TEST
TEST(ConnectToNamedPort, InvalidPointerTest)
{
    TestNamedPortLeak leakTest;
    nn::Result result;
    nn::svc::Handle portHandle;
    uintptr_t addr;

    // 前準備
    result = nn::svc::ManageNamedPort(&portHandle, PortName, 1);
    // 前のテストで失敗し、名前付きポートが残っている
    if (result <= nn::svc::ResultBusy())
    {
        result = nn::svc::ManageNamedPort(&portHandle, PortName, 0);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::ManageNamedPort(&portHandle, PortName, 1);
        ASSERT_RESULT_SUCCESS(result);
    }
    else
    {
        ASSERT_RESULT_SUCCESS(result);
    }

#ifdef INVALID_POINTER_TEST
    // TEST 26-5
    // NULL を渡すと失敗する
    result = nn::svc::ConnectToNamedPort(NULL, PortName);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 26-7
    // MemoryPermission_None の領域を渡すと失敗する
    addr = g_FreeAreaBegin;
    CheckAddressPermission(addr, nn::svc::MemoryPermission_None);
    result = nn::svc::ConnectToNamedPort(
            reinterpret_cast<nn::svc::Handle*>(addr), PortName);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

    // TEST 26-8
    // MemoryPermission_Read の領域を渡すと失敗する
#ifdef INVALID_POINTER_TEST
    addr = reinterpret_cast<uintptr_t>(&TmpVar);
    CheckAddressPermission(addr, nn::svc::MemoryPermission_Read);
    result = nn::svc::ConnectToNamedPort(
            reinterpret_cast<nn::svc::Handle*>(addr), PortName);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 26-9
    // MemoryPermission_ReadExecute の領域を渡すと失敗する
    addr = reinterpret_cast<uintptr_t>(nnMain);
    CheckAddressPermission(addr, nn::svc::MemoryPermission_ReadExecute);
    result = nn::svc::ConnectToNamedPort(
            reinterpret_cast<nn::svc::Handle*>(addr), PortName);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

    // 終了処理
    result = nn::svc::CloseHandle(portHandle);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::ManageNamedPort(&portHandle, PortName, 0);
    ASSERT_RESULT_SUCCESS(result);
}
#endif // INVALID_POINTER_TEST

TEST(ConnectToNamedPort, NameTest)
{
    TestNamedPortLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;

    // TEST 26-10
    // 指定された名前のポートがないと失敗する
    result = nn::svc::ConnectToNamedPort(&handle, "MissName");
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());

    // TEST 26-11
    // 12文字以上の名前は指定できない
    result = nn::svc::ConnectToNamedPort(&handle, "123456789012");
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultOutOfRange());
}

