﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "test_Break.h"
#include <nn/nn_Assert.h>
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <nn/nn_BitTypes.h>
#include <cstring>
#include <nn/init.h>

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern "C" void nnMain()
{
    InitTestMemory();
    nn::Result result;
    nn::svc::Handle clientSession;
    nn::Bit32* pMsgBuffer;
    nn::Bit64 pid;

    result = nn::svc::ConnectToNamedPort(&clientSession, PortName);
    NN_ASSERT_RESULT_SUCCESS(result);

    pMsgBuffer = nn::svc::ipc::GetMessageBuffer();

    result = nn::svc::GetProcessId(&pid, nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    NN_ASSERT_RESULT_SUCCESS(result);

    nn::svc::ipc::MessageBuffer ipcMsg(pMsgBuffer);
    int offset = ipcMsg.Set(
        nn::svc::ipc::MessageBuffer::MessageHeader(BreakTag_User, 1, 0, 0, 0, 0, 0, 0));
    offset = ipcMsg.Set(nn::svc::ipc::MessageBuffer::SpecialHeader(true, 0, 0));
    offset = ipcMsg.SetProcessId(offset, pid);

    result = nn::svc::SendSyncRequest(clientSession);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::CloseHandle(clientSession);
    NN_ASSERT_RESULT_SUCCESS(result);

    // TEST 33-1
    // BreakReason_Panic を起こすことが出来る
    int32_t data = static_cast<int32_t>(BreakTag_User);
    nn::svc::Break(nn::svc::BreakReason_User, reinterpret_cast<uintptr_t>(&data), sizeof(int32_t));
}

