﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sdmmc_PortSdCard0.h"
#if (defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1))
    #include "sdmmc_SdmmcController.tegra-k1.h"
#endif
#if (defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_HARDWARE_NX))
    #include "sdmmc_SdmmcController.tegra-x1.h"
#endif

namespace nn { namespace sdmmc1 {
namespace detail {

namespace
{
    #if (defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1))
        Sdmmc3Controller g_SdCard0HostController;
    #else   // NN_BUILD_CONFIG_HARDWARE_JETSONTK2, NN_BUILD_CONFIG_HARDWARE_NX
        Sdmmc1Controller g_SdCard0HostController;
    #endif
    #if (defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_SD_CARD_0_FOR_DEBUG))  // デバッグ用に SD カードポート 0 番に MMC を接続する場合
        MmcDeviceAccessor g_SdCard0DeviceAccessor(&g_SdCard0HostController);
    #else   // 通常
        #if (defined(NN_DETAIL_SDMMC_SD_CARD_DETECTOR_ENABLE))
            const int SdCard0DebounceMicroSeconds = 30; // TODO: 適切な Debounce 時間の設定（上限 128ms）
            DeviceDetector g_SdCard0Detector(nn::gpio::GpioPadName_SdCd, nn::gpio::GpioValue_Low, SdCard0DebounceMicroSeconds);
            SdCardDeviceAccessor g_SdCard0DeviceAccessor(&g_SdCard0HostController, &g_SdCard0Detector);
        #else
            SdCardDeviceAccessor g_SdCard0DeviceAccessor(&g_SdCard0HostController);
        #endif
    #endif
}

IHostController* GetHostControllerOfPortSdCard0() NN_NOEXCEPT
{
    return &g_SdCard0HostController;
}

IDeviceAccessor* GetDeviceAccessorOfPortSdCard0() NN_NOEXCEPT
{
    return &g_SdCard0DeviceAccessor;
}

#if (defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_SD_CARD_0_FOR_DEBUG))  // デバッグ用に SD カードポート 0 番に MMC を接続する場合
    MmcDeviceAccessor* GetMmcDeviceAccessorOfPortSdCard0() NN_NOEXCEPT
    {
        return &g_SdCard0DeviceAccessor;
    }
#else
    SdCardDeviceAccessor* GetSdCardDeviceAccessorOfPortSdCard0() NN_NOEXCEPT
    {
        return &g_SdCard0DeviceAccessor;
    }
#endif

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {
