﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/spy/spy_SpyController.h>

extern bool g_ExecuteTest;

TEST(IncludeTest, spy_SpyController_h)
{
    if (g_ExecuteTest)
    {
        nn::spy::SpyController controller;
        nn::spy::SpyModule* pModule = NULL;

        nn::spy::SpyController::InitializeArg initializeArg;
        (void)nn::spy::SpyController::GetRequiredMemorySize(initializeArg);
        controller.Initialize(initializeArg, NULL /*buffer*/, 0 /*bufferLength*/);

        controller.Finalize();

        nn::spy::SpyController::OpenArg openArg;
        (void)controller.Open(openArg);

        controller.Close();

        (void)controller.IsInitialized();
        (void)controller.IsOpened();
        (void)controller.IsConnecting();
        (void)controller.IsConnected();

        (void)controller.GetCurrentApplicationFrame();

        controller.SetCurrentApplicationFrame(0 /*value*/);

        (void)controller.GetCurrentAudioFrame();

        controller.SetCurrentAudioFrame(0 /*value*/);

        (void)controller.RegisterModule(*pModule);

        controller.UnregisterModule(*pModule);

        (void)controller.GetDebugModule();

        (void)controller.GetLogModule();

        (void)controller.GetMarkerModule();

        (void)controller.GetPlotModule();
    }

    EXPECT_TRUE(true);
}
