﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/os/os_Tick.h>
#include <nn/spy/spy_PlotFloat.h>

extern bool g_ExecuteTest;

TEST(IncludeTest, spy_PlotFloat_h)
{
    if (g_ExecuteTest)
    {
        nn::spy::PlotFloat plotFloat1;
        nn::spy::PlotFloat plotFloat2("name");
        nn::spy::PlotFloat plotFloat3("name", 0 /*minValue*/, 0 /*maxValue*/, 0 /*r*/, 0 /*g*/, 0 /*b*/);

        plotFloat1.SetRange(0 /*minValue*/, 0 /*maxValue*/);
        plotFloat1.SetInterpolationMode(nn::spy::PlotFloat::InterpolationMode_Linear);
        plotFloat1.PushValue(0 /*value*/);
        plotFloat1.PushValueAt(0 /*value*/, nn::os::Tick(0) /*timestamp*/);
    }

    EXPECT_TRUE(true);
}
