﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.IO;
using System.Reflection;

namespace ToolVersionChecker
{
    /// <summary>
    /// JSON のシリアライズ、デシリアライズを補助するクラスです。
    /// </summary>
    public class JsonSerializerHelper
    {
        /// <summary>
        /// JSON 文字列をデシリアライズします。
        /// </summary>
        /// <typeparam name="SerializeType">デシリアライズするクラスの型です。</typeparam>
        /// <param name="inputString">入力文字列です。</param>
        /// <returns>デシリアライズ後のオブジェクトを返します。</returns>
        public static SerializeType Deserialize<SerializeType>(string inputString)
        {
            var serializer = new DataContractJsonSerializer(typeof(SerializeType));
            var jsonBytes = Encoding.Unicode.GetBytes(inputString);
            var sr = new MemoryStream(jsonBytes);
            SerializeType deserializedData = (SerializeType)serializer.ReadObject(sr);

            return deserializedData;
        }

        /// <summary>
        /// JSON 文字列にシリアライズします。
        /// </summary>
        /// <typeparam name="SerializeType">シリアライズするクラスの型です。</typeparam>
        /// <param name="inputData">入力データです。</param>
        /// <returns>シリアライズ後の文字列を返します。</returns>
        public static string Serialize<SerializeType>(SerializeType inputData)
        {
            var serializer = new DataContractJsonSerializer(typeof(SerializeType));
            var stream = new MemoryStream();
            serializer.WriteObject(stream, inputData);
            stream.Position = 0;
            var reader = new StreamReader(stream);
            return reader.ReadToEnd();
        }
    }
}
