﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <map>
#include <memory>

#include <nn/nn_Common.h>
#include "TestAppSimple_Scene.h"
#include "TestAppSimple_OperationEnvScene.h"

class Application
{
    NN_DISALLOW_COPY(Application);

public:
    Application() NN_NOEXCEPT;
    virtual ~Application() NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Run() NN_NOEXCEPT;

private:
    void SetStartupOperationEnvironmentValue() NN_NOEXCEPT;
    void GetLaunchStorageInfo(LaunchStorageInfo* outStorageInfo) NN_NOEXCEPT;
    void PollOperationModeChangeMessage() NN_NOEXCEPT;

private:
    Scene* m_CurrentScenePtr;
    // 特別な画面なため、独自にポインタを保持させる
    OperationEnvScene* m_OperationEnvScenePtr;
    std::map<NextAction, std::unique_ptr<Scene>> m_ApplicationSceneList;

    nn::gfx::util::DebugFontTextWriter m_DebugFontWriter;
};
