﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Text;
using Nintendo.Foundation.IO;

namespace MakeTestApplication
{
    internal class Arguments
    {
        private CommandLineParams parameters;

        /// <summary>
        /// 解析した結果のパラメータを渡します。
        /// </summary>
        public CommandLineParams Params
        {
            get { return parameters; }
        }

        /// <summary>
        /// コマンドラインオプションを解析します
        /// </summary>
        /// <returns>解析の成否</returns>
        public bool ParseArgs(string[] args)
        {
            var settings = new CommandLineParserSettings()
            {
                ApplicationDescription = "プログラムIDを読み込んで、ダミーアプリである .nsp ファイルを作成します。",
                HelpWriter = text =>
                {
                    Console.WriteLine(text);
                },
            };

            if (!new CommandLineParser(settings).ParseArgs(args, out parameters))
            {
                return false;
            }

            return true;
        }

        /// <summary>
        /// 引数解析が失敗したときに呼ばれるメソッドです。
        /// </summary>
        /// <param name="errorInfo">エラーの情報</param>
        private void CommandLineParseError(CommandLineErrorInfo errorInfo)
        {
            Console.Error.WriteLine("CommandLine: {0}", errorInfo.ErrorMessage);
        }
    }
}
