﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace PCToolTester
{
    public static class EnvironmentUtility
    {
        /// <summary>
        /// $(xxx) で記述された環境変数を展開します。
        /// </summary>
        public static string ExpandEnvironmentVariables(string sourceStr)
        {
            string resultStr = sourceStr;

            // 環境変数変換記述 $(xxx) を探して置換します。
            foreach (Match match in Regex.Matches(sourceStr, "\\$\\([^)]+\\)"))
            {
                string matchStr = match.ToString();
                string envValue = GetEnvironmentVariable(Regex.Match(matchStr, "[^$(].+[^)]").ToString());

                if (envValue != null)
                {
                    // $(xxx) を対応する環境変数値で変換します。
                    resultStr = resultStr.Replace(matchStr, envValue);
                }
            }

            return resultStr;
        }

        /// <summary>
        /// 環境変数の値を取得します。
        /// </summary>
        /// <param name="name"></param>
        /// <returns>環境変数の値を返します。指定した名前の環境変数が定義されていないときは null を返します。</returns>
        public static string GetEnvironmentVariable(string name)
        {
            return Environment.GetEnvironmentVariable(name);
        }
    }
}
