﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Collections.Specialized;

namespace NintendoWare.Spy.Tests
{
    [TestClass()]
    public class PlotSpyModelTests
    {
        [TestMethod()]
        public void ExplicitNotifyObservableCollectionTest()
        {
            var verify = new List<Action>();

            var collection = new PlotSpyModel.ExplicitNotifyObservableCollection<int>();

            int ccCount = 0;
            collection.CollectionChanged += (sender, args) =>
            {
                var count = ccCount++;

                verify.Add(() =>
                {
                    Assert.AreEqual(collection, sender);
                    Assert.AreEqual(NotifyCollectionChangedAction.Add, args.Action);
                    Assert.AreEqual(1, args.NewItems.Count);
                    Assert.AreEqual(count + 1, args.NewItems[0]);
                    Assert.AreEqual(count, args.NewStartingIndex);
                });
            };

            int pcCount = 0;
            collection.PropertyChanged += (sender, args) =>
            {
                pcCount++;
                verify.Add(() =>
                {
                    Assert.AreEqual(collection, sender);
                    Assert.AreEqual(nameof(collection.Count), args.PropertyName);
                });
            };

            var notify = new List<Action>();

            collection.Add(1, notify);

            Assert.AreEqual(1, collection.Count);
            Assert.AreEqual(1, collection[0]);

            collection.Add(2, notify);

            Assert.AreEqual(2, collection.Count);
            Assert.AreEqual(2, collection[1]);

            notify.ForEach(it => it());

            Assert.AreEqual(2, ccCount);
            Assert.AreEqual(2, pcCount);
            verify.ForEach(it => it());
        }
    }
}
