﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.IO;
using System.Linq;

namespace NintendoWare.Spy.Extensions.Tests
{
    [TestClass()]
    public class TextReaderExtensionTests
    {
        [TestMethod()]
        public void ReadLinesTest()
        {
            using (var reader = new StringReader(string.Empty))
            {
                Assert.IsTrue(reader.ReadLines().SequenceEqual(new string[] { }));
            }

            using (var reader = new StringReader("\r\n"))
            {
                Assert.IsTrue(reader.ReadLines().SequenceEqual(new string[] { string.Empty }));
            }

            using (var reader = new StringReader("aaa"))
            {
                Assert.IsTrue(reader.ReadLines().SequenceEqual(new string[] { "aaa" }));
            }

            using (var reader = new StringReader("aaa\r\n"))
            {
                Assert.IsTrue(reader.ReadLines().SequenceEqual(new string[] { "aaa" }));
            }

            using (var reader = new StringReader("aaa\r\nbbb\r\nccc"))
            {
                Assert.IsTrue(reader.ReadLines().SequenceEqual(new string[] { "aaa", "bbb", "ccc" }));
            }
        }
    }
}
