﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace NintendoWare.Spy.Settings.Tests
{
    [TestClass()]
    public class TeamSettingsServiceTests
    {
        /// <summary>
        /// チーム設定を読めるかのテストです。
        /// </summary>
        [TestMethod()]
        public void LoadTest()
        {
            var pluginDirectories = new string[]
            {
                "TeamSettingsServiceTests.Plugins1",
                "TeamSettingsServiceTests.Plugins2",
            };

            pluginDirectories.ForEach(it => Directory.CreateDirectory(it));

            try
            {
                var teamSettingsService = new TeamSettingsService();

                teamSettingsService.Load("Resources/raw/teamSettings.xml");

                Assert.IsTrue(pluginDirectories
                    .Select(it => Path.GetFullPath(it))
                    .SequenceEqual(teamSettingsService.PluginDirectoryPaths));

                Assert.IsTrue(teamSettingsService.GetWarningMessage().Contains("TeamSettingsServiceTests.PluginsNotExist"));
            }
            finally
            {
                pluginDirectories.ForEach(it =>
                {
                    try
                    {
                        Directory.Delete(it);
                    }
                    catch
                    {
                    }
                });
            }
        }
    }
}
