﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.Foundation.IO;
using System.IO;
using System.Reflection;

namespace Nintendo.Atk.Binary
{
    /// <summary>
    /// nn::audio opus ファイルの OpusBasicInfo テストです。
    /// </summary>
    [TestClass]
    public class AudioOpusBasicInfoTest
    {
        private const string OpusDirectoryPath = @"Resources\\opus\";

        /// <summary>
        /// 読み込みテスト
        /// </summary>
        [TestMethod]
        [DeploymentItem(OpusDirectoryPath + "sin1ch48k_fr20ms.opus", OpusDirectoryPath)]
        [DeploymentItem(OpusDirectoryPath + "sin2ch48k_cvbr.opus", OpusDirectoryPath)]
        public void Read()
        {
            // モノラル / 48kHz / フレームサイズ 20ms / CBR
            {
                var basicInfo = Read($"{OpusDirectoryPath}sin1ch48k_fr20ms.opus");
                Assert.AreEqual(1, basicInfo.ChannelCount);
                Assert.AreEqual(48000, basicInfo.SampleRate);
                Assert.AreEqual(0xf0, basicInfo.FrameDataSize);
            }

            // ステレオ / 48kHz / CVBR
            {
                var basicInfo = Read($"{OpusDirectoryPath}sin2ch48k_cvbr.opus");
                Assert.AreEqual(2, basicInfo.ChannelCount);
                Assert.AreEqual(48000, basicInfo.SampleRate);
                Assert.AreEqual(0, basicInfo.FrameDataSize);
            }
        }

        private AudioOpusBasicInfo Read(string filePath)
        {
            using (var stream = File.OpenRead(filePath))
            {
                using (var reader = LittleEndianBinaryReader.Create(stream))
                {
                    return AudioOpusBasicInfo.FromBinary(reader);
                }
            }
        }
    }
}
