﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Diagnostics.CodeAnalysis;

namespace Nintendo.Atk.Binary
{
    /// <summary>
    /// bfwav ファイルの入力テストです。(x64)
    /// </summary>
    [TestClass]
    [DeploymentItem(@"Nintendo.Atk.Native.dll", "")]
    [SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1121:UseBuiltInTypeAlias", Justification = "バイナリのサイズを明示するため")]
    public class BfwavReaderX64Test
    {
        private const string BfwavDirectoryPath = @"Resources\\bfwav\";
        private const string RawDirectoryPath = @"Resources\\raw\";

        /// <summary>
        /// WaveBinaryInfo 読み込みテスト
        /// </summary>
        [TestMethod]
        [DeploymentItem(BfwavDirectoryPath + "sin2ch48kLoop.pcm16.bfwav", BfwavDirectoryPath)]
        [DeploymentItem(BfwavDirectoryPath + "sin2ch48kLoop.adpcm.bfwav", BfwavDirectoryPath)]
        [DeploymentItem(BfwavDirectoryPath + "sin2ch48k.adpcm.bfwav", BfwavDirectoryPath)]
        public void ReadWaveBinaryInfo()
        {
            BfwavReaderTest.ReadWaveBinaryInfo();
        }

        /// <summary>
        /// デコードテスト
        /// </summary>
        [TestMethod]
        [DeploymentItem(BfwavDirectoryPath + "sin2ch48kLoop.pcm16.bfwav", BfwavDirectoryPath)]
        [DeploymentItem(BfwavDirectoryPath + "sin2ch48k.adpcm.bfwav", BfwavDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin2ch48kLoop.pcm16.bfwav.ch0.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin2ch48kLoop.pcm16.bfwav.ch1.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin2ch48k.adpcm.bfwav.ch0.raw.wav", RawDirectoryPath)]
        [DeploymentItem(RawDirectoryPath + "sin2ch48k.adpcm.bfwav.ch1.raw.wav", RawDirectoryPath)]
        public void DecodeAll()
        {
            BfwavReaderTest.DecodeAll();
        }
    }
}
