﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/repair/repair_FileSystem.h>

namespace nnt
{
    namespace repair
    {
        class TestEnvironment
        {
        public:
            TestEnvironment();
            std::string GetWorkingDirectory();
            std::shared_ptr<nn::repair::FileSystem> GetManuFileSystem();
            std::shared_ptr<nn::repair::FileSystem> GetNnfsFileSystem();
            bool IsManuEnabled();

        private:
            std::string m_WorkingDirectory;
            std::shared_ptr<nn::repair::FileSystem> m_ManuFileSystem;
            std::shared_ptr<nn::repair::FileSystem> m_NnfsFileSystem;
            bool m_IsManuEnabled;
        };

        TestEnvironment& GetTestEnv();
    }
}
