﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyWindowsTargetPlatformVersion : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }
            if (conf.SubRootName == "Users")
            {
                // don't care
                return;
            }

            switch (conf.PlatformToolset)
            {
                case "v120":
                    break;
                case "v140":
                    Assert.Equal("8.1", ep.Properties["WindowsTargetPlatformVersion"]);
                    break;
                case "v141":
                    Assert.Equal("10.0.15063.0", ep.Properties["WindowsTargetPlatformVersion"]);
                    break;
                default:
                    throw new ArgumentException($"不明な PlatformToolset です: {conf.PlatformToolset}", nameof(conf.PlatformToolset));
            }
        }
    }
}
