﻿using System;
using System.Linq;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkAdditionalNSODependencies : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.ProjectType == ProjectType.Library)
            {
                return;
            }

            switch (conf.Platform)
            {
                case "Win32":
                case "x64":
                    InvokeWinPlatformAssertions(conf, ep, expander);
                    break;
                case "NX32":
                case "NX64":
                    InvokeNXPlatformAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の Platform です: {0}", conf.Platform));
                    break;
            }
        }

        private void InvokeWinPlatformAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            // dll は使用しない
        }

        private void InvokeNXPlatformAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Tests":
                    // don't care
                    break;
                case "Samples":
                case "Users":
                    switch (conf.ProjectType)
                    {
                        case ProjectType.Library:
                            // don't care
                            break;
                        case ProjectType.DynamicLibrary:
                            AssertUtil.AssertSequenceEqual(
                                Util.SplitMsBuildValue(ep.Metadata["Link.AdditionalNSODependencies"]),
                                Enumerable.Empty<string>());
                            break;
                        case ProjectType.Program:
                            AssertMsBuildValueContainsElements(expander,
                                ep.Metadata["Link.AdditionalNSODependencies"],
                                "");
                            break;
                        case ProjectType.ProgramWithoutSdkNso:
                        case ProjectType.SystemProgram:
                            AssertUtil.AssertSequenceEqual(
                                Util.SplitMsBuildValue(ep.Metadata["Link.AdditionalNSODependencies"]),
                                Enumerable.Empty<string>());
                            break;
                        default:
                            Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                            break;
                    }
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }
    }
}
