﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompilePreprocessorDefinitions : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.BuildType)
            {
                case "Debug":
                    AssertMsBuildValueContainsElements(expander,
                        ep.Metadata["ClCompile.PreprocessorDefinitions"],
                        "NN_NINTENDO_SDK;NN_SDK_BUILD_DEBUG");
                    break;
                case "Develop":
                    AssertMsBuildValueContainsElements(expander,
                        ep.Metadata["ClCompile.PreprocessorDefinitions"],
                        "NN_NINTENDO_SDK;NN_SDK_BUILD_DEVELOP");
                    break;
                case "Release":
                    AssertMsBuildValueContainsElements(expander,
                        ep.Metadata["ClCompile.PreprocessorDefinitions"],
                        "NN_NINTENDO_SDK;NN_SDK_BUILD_RELEASE");
                    break;
                default:
                    Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                    break;
            }

            if (conf.IsDevelopmentSubRoot && conf.ProjectType == ProjectType.Library)
            {
                AssertMsBuildValueContainsElements(expander,
                    ep.Metadata["ClCompile.PreprocessorDefinitions"],
                    "NN_SDK_BUILD_LIBRARY");
            }

            if (conf.IsWinPlatform)
            {
                AssertMsBuildValueContainsElements(expander,
                    ep.Metadata["ClCompile.PreprocessorDefinitions"],
                    "WIN32;_CRT_SECURE_NO_WARNINGS;_SCL_SECURE_NO_WARNINGS;"
                    + "NTDDI_WIN7SP1=0x06010100;_WIN32_WINNT_WINTHRESHOLD=0x0A00;WINAPI_PARTITION_SYSTEM=0");

                switch (conf.BuildType)
                {
                    case "Debug":
                        AssertMsBuildValueContainsElements(expander,
                            ep.Metadata["ClCompile.PreprocessorDefinitions"],
                            "_DEBUG");
                        break;
                    case "Develop":
                    case "Release":
                        AssertMsBuildValueContainsElements(expander,
                            ep.Metadata["ClCompile.PreprocessorDefinitions"],
                            "NDEBUG");
                        break;
                    default:
                        Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                        break;
                }
            }
        }
    }
}
