﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileDiagnosticsFormat : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }

            switch (conf.PlatformToolset)
            {
                case "v120":
                case "v140":
                    // v140 までは本メタデータは存在しない
                    break;
                case "v141":
                    switch (conf.SubRootName)
                    {
                        case "Alice":
                        case "Chris":
                        case "Eris":
                        case "Iris":
                        case "NintendoWare":
                        case "Tests":
                            Assert.Equal("Caret", ep.Metadata["ClCompile.DiagnosticsFormat"]);
                            break;
                        case "Samples":
                        case "Users":
                            // デフォルト値のままであること
                            Assert.Equal("Classic", ep.Metadata["ClCompile.DiagnosticsFormat"]);
                            break;
                        default:
                            throw new ArgumentException(string.Format("{0}: 未知の SubRootName です。", conf.SubRootName), "conf");
                    }
                    break;
                default:
                    throw new ArgumentException($"不明な PlatformToolset です: {conf.PlatformToolset}", nameof(conf.PlatformToolset));
            }
        }
    }
}
