﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PropertySheetsTest
{
    /// <summary>
    /// 1 つのプロジェクト構成 （Configuration|Platform）です。
    /// </summary>
    public class ConfigurationPair : IEquatable<ConfigurationPair>
    {
        private readonly string configuration;
        private readonly string platform;

        public ConfigurationPair(string configuration, string platform)
        {
            this.configuration = configuration;
            this.platform = platform;
        }

        public string Configuration { get { return configuration; } }
        public string Platform { get { return platform; } }

        public bool Equals(ConfigurationPair other)
        {
            return configuration == other.configuration && platform == other.platform;
        }

        public override bool Equals(object obj)
        {
            if (obj == null || GetType() != obj.GetType())
            {
                return false;
            }

            return Equals((ConfigurationPair)obj);
        }

        public static bool operator ==(ConfigurationPair lhs, ConfigurationPair rhs)
        {
            return lhs.Equals(rhs);
        }

        public static bool operator !=(ConfigurationPair lhs, ConfigurationPair rhs)
        {
            return !lhs.Equals(rhs);
        }

        public override int GetHashCode()
        {
            return new Tuple<string, string>(configuration, platform).GetHashCode();
        }

        public override string ToString()
        {
            return string.Format("{0}|{1}", configuration, platform);
        }
    }
}
