﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include "testSf_AddParameter.h"
#include "testSf_Structs.h"
#include <cstdint>
#include <nn/applet/applet_Types.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nnt { namespace testsf { // NOLINT(whitespace/braces)

class IAllFunctionTests;

class IAllFunctionTestsBase;

class IAllFunctionTestsBase0;

class ITestSession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAllFunctionTestsBase0, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAllFunctionTestsBase0)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(EchoInt, (int), (int x))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StoreIntWithResult, (int x))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(StoreInt, (int x))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(LoadInt, (int))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(FlipBits, (const ::nn::sf::OutBuffer& outBuffer, const ::nn::sf::InBuffer& inBuffer))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAllFunctionTestsBase0)

        int EchoInt(int x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(EchoInt, (int), (x));
        }

        ::nn::Result StoreIntWithResult(int x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StoreIntWithResult, (x));
        }

        void StoreInt(int x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(StoreInt, (x));
        }

        int LoadInt() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(LoadInt, (int));
        }

        void FlipBits(const ::nn::sf::OutBuffer& outBuffer, const ::nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(FlipBits, (outBuffer, inBuffer));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAllFunctionTestsBase0
    {
    public:
        int EchoInt(int x) NN_NOEXCEPT;
        nn::Result StoreIntWithResult(int x) NN_NOEXCEPT;
        void StoreInt(int x) NN_NOEXCEPT;
        int LoadInt() NN_NOEXCEPT;
        void FlipBits(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    int EchoInt(int x) NN_NOEXCEPT;
    nn::Result StoreIntWithResult(int x) NN_NOEXCEPT;
    void StoreInt(int x) NN_NOEXCEPT;
    int LoadInt() NN_NOEXCEPT;
    void FlipBits(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nnt::testsf::IAllFunctionTestsBase0))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoInt, (int), (int x))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(EchoInt, (int), (x));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StoreIntWithResult, (int x))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StoreIntWithResult, (x));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(StoreInt, (int x))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(StoreInt, (x));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(LoadInt, (int))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(LoadInt, (int));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(FlipBits, (const ::nn::sf::OutBuffer& outBuffer, const ::nn::sf::InBuffer& inBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(FlipBits, (outBuffer, inBuffer));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nnt::testsf::IAllFunctionTestsBase0>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nnt::testsf::IAllFunctionTestsBase0))

    // int EchoInt(int x) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EchoInt)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (x))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EchoInt)

    // nn::Result StoreIntWithResult(int x) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StoreIntWithResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (x))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StoreIntWithResult)

    // void StoreInt(int x) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StoreInt)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (x))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StoreInt)

    // int LoadInt() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadInt)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadInt)

    // void FlipBits(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FlipBits)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outBuffer, inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FlipBits)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nnt::testsf::IAllFunctionTestsBase0, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nnt::testsf::IAllFunctionTestsBase0))

    // int EchoInt(int x) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoInt, (int), (int x))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EchoInt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EchoInt)
    }

    // nn::Result StoreIntWithResult(int x) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StoreIntWithResult, (int x))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StoreIntWithResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StoreIntWithResult)
    }

    // void StoreInt(int x) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(StoreInt, (int x))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StoreInt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StoreInt)
    }

    // int LoadInt() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(LoadInt, (int))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadInt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadInt)
    }

    // void FlipBits(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(FlipBits, (const ::nn::sf::OutBuffer& outBuffer, const ::nn::sf::InBuffer& inBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FlipBits)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FlipBits)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nnt::testsf::IAllFunctionTestsBase0>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nnt::testsf::IAllFunctionTestsBase0))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EchoInt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EchoInt)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StoreIntWithResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StoreIntWithResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StoreInt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StoreInt)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadInt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadInt)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FlipBits)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FlipBits)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EchoInt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StoreIntWithResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StoreInt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadInt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FlipBits)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nnt::testsf::IAllFunctionTestsBase0))

namespace nnt { namespace testsf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAllFunctionTestsBase, (::nnt::testsf::IAllFunctionTestsBase0))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAllFunctionTestsBase)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(Add, (::std::int32_t), (::nnt::testsf::AddParameter p))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(LoadIntByOut, (::nn::sf::Out<int> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(EchoStruct, (::nnt::testsf::Struct2), (const ::nnt::testsf::Struct1& s))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(EchoStruct2, (::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(OpenSession, (::nn::sf::SharedPointer<::nnt::testsf::ITestSession>), (int value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(OpenSession2, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::ITestSession>> pOut, int value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetSessionCount, (int))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetNativeHandle2, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(MoveNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(InNativeHandle, (::nn::sf::NativeHandle&& e))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(MoveInNativeHandle, (::nn::sf::NativeHandle&& e))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SetClientProcessId, (::nn::Bit64 pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetClientProcessId, (::nn::sf::Out<::nn::Bit64> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SquareArrayElement, (const ::nn::sf::OutArray<::std::int32_t>& dst, const ::nn::sf::InArray<::std::int32_t>& src))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(EchoStruct3, (::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(MoveNativeHandle2, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(EchoBool, (bool), (bool x))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(EchoUInt16, (::std::uint16_t), (::std::uint16_t x))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(EchoUInt64, (::std::uint64_t), (::std::uint64_t x))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes2, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(SquareArrayElement2, (const ::nn::sf::OutArray<::std::int32_t>& dst, const ::nn::sf::InArray<::std::int32_t>& src))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(EchoStruct4, (::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeferProcess)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetNullObject, (::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(GetNullObject2, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CauseError, (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes3, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes4, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckAruid, (::nn::Bit64 aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckAruid2, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(OpenSessionChar, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::ITestSession>> pOut, ::nn::sf::Out<char> pCharOut, char x))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetInlineContextTest, (::std::uint32_t))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetFsInlineContextTest, (::std::uint8_t))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAllFunctionTestsBase)

        ::std::int32_t Add(::nnt::testsf::AddParameter p) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(Add, (::std::int32_t), (p));
        }

        ::std::int32_t SumAndSubBytes(const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(SumAndSubBytes, (::std::int32_t), (outSum, outSub, inBuffer1, inBuffer2));
        }

        void LoadIntByOut(::nn::sf::Out<int> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(LoadIntByOut, (pOut));
        }

        ::nnt::testsf::Struct2 EchoStruct(const ::nnt::testsf::Struct1& s) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(EchoStruct, (::nnt::testsf::Struct2), (s));
        }

        void EchoStruct2(::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(EchoStruct2, (pOut, s));
        }

        ::nn::sf::SharedPointer<::nnt::testsf::ITestSession> OpenSession(int value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(OpenSession, (::nn::sf::SharedPointer<::nnt::testsf::ITestSession>), (value));
        }

        void OpenSession2(::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::ITestSession>> pOut, int value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(OpenSession2, (pOut, value));
        }

        int GetSessionCount() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetSessionCount, (int));
        }

        void GetNativeHandle2(::nn::sf::Out<::nn::sf::NativeHandle> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetNativeHandle2, (pOut));
        }

        void MoveNativeHandle(::nn::sf::Out<::nn::sf::NativeHandle> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(MoveNativeHandle, (pOut));
        }

        void InNativeHandle(::nn::sf::NativeHandle&& e) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(InNativeHandle, (::std::move(e)));
        }

        void MoveInNativeHandle(::nn::sf::NativeHandle&& e) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(MoveInNativeHandle, (::std::move(e)));
        }

        void SetClientProcessId(::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SetClientProcessId, (pid));
        }

        void GetClientProcessId(::nn::sf::Out<::nn::Bit64> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetClientProcessId, (pOut));
        }

        void SquareArrayElement(const ::nn::sf::OutArray<::std::int32_t>& dst, const ::nn::sf::InArray<::std::int32_t>& src) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SquareArrayElement, (dst, src));
        }

        void EchoStruct3(::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(EchoStruct3, (pOut, s));
        }

        void MoveNativeHandle2(::nn::sf::Out<::nn::sf::NativeHandle> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(MoveNativeHandle2, (pOut));
        }

        bool EchoBool(bool x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(EchoBool, (bool), (x));
        }

        ::std::uint16_t EchoUInt16(::std::uint16_t x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(EchoUInt16, (::std::uint16_t), (x));
        }

        ::std::uint64_t EchoUInt64(::std::uint64_t x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(EchoUInt64, (::std::uint64_t), (x));
        }

        ::std::int32_t SumAndSubBytes2(const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(SumAndSubBytes2, (::std::int32_t), (outSum, outSub, inBuffer1, inBuffer2));
        }

        void SquareArrayElement2(const ::nn::sf::OutArray<::std::int32_t>& dst, const ::nn::sf::InArray<::std::int32_t>& src) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(SquareArrayElement2, (dst, src));
        }

        void EchoStruct4(::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(EchoStruct4, (pOut, s));
        }

        ::nn::Result DeferProcess() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeferProcess);
        }

        ::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests> GetNullObject() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetNullObject, (::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>));
        }

        void GetNullObject2(::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(GetNullObject2, (pOut));
        }

        ::nn::Result CauseError(const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CauseError, (outSum, outSub, inBuffer1, inBuffer2));
        }

        ::std::int32_t SumAndSubBytes3(const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(SumAndSubBytes3, (::std::int32_t), (outSum, outSub, inBuffer1, inBuffer2));
        }

        ::std::int32_t SumAndSubBytes4(const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(SumAndSubBytes4, (::std::int32_t), (outSum, outSub, inBuffer1, inBuffer2));
        }

        ::nn::Result CheckAruid(::nn::Bit64 aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckAruid, (aruid));
        }

        ::nn::Result CheckAruid2(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckAruid2, (aruid));
        }

        void OpenSessionChar(::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::ITestSession>> pOut, ::nn::sf::Out<char> pCharOut, char x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(OpenSessionChar, (pOut, pCharOut, x));
        }

        ::std::uint32_t GetInlineContextTest() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetInlineContextTest, (::std::uint32_t));
        }

        ::std::uint8_t GetFsInlineContextTest() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetFsInlineContextTest, (::std::uint8_t));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAllFunctionTestsBase : public ::nnt::testsf::IAllFunctionTestsBase0
    {
    public:
        std::int32_t Add(nnt::testsf::AddParameter p) NN_NOEXCEPT;
        std::int32_t SumAndSubBytes(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
        void LoadIntByOut(nn::sf::Out<int> pOut) NN_NOEXCEPT;
        nnt::testsf::Struct2 EchoStruct(const nnt::testsf::Struct1& s) NN_NOEXCEPT;
        void EchoStruct2(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
        nn::sf::SharedPointer<nnt::testsf::ITestSession> OpenSession(int value) NN_NOEXCEPT;
        void OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, int value) NN_NOEXCEPT;
        int GetSessionCount() NN_NOEXCEPT;
        void GetNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
        void MoveNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
        void InNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT;
        void MoveInNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT;
        void SetClientProcessId(nn::Bit64 pid) NN_NOEXCEPT;
        void GetClientProcessId(nn::sf::Out<nn::Bit64> pOut) NN_NOEXCEPT;
        void SquareArrayElement(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT;
        void EchoStruct3(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
        void MoveNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
        bool EchoBool(bool x) NN_NOEXCEPT;
        std::uint16_t EchoUInt16(std::uint16_t x) NN_NOEXCEPT;
        std::uint64_t EchoUInt64(std::uint64_t x) NN_NOEXCEPT;
        std::int32_t SumAndSubBytes2(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
        void SquareArrayElement2(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT;
        void EchoStruct4(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
        nn::Result DeferProcess() NN_NOEXCEPT;
        nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests> GetNullObject() NN_NOEXCEPT;
        void GetNullObject2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests>> pOut) NN_NOEXCEPT;
        nn::Result CauseError(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
        std::int32_t SumAndSubBytes3(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
        std::int32_t SumAndSubBytes4(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
        nn::Result CheckAruid(nn::Bit64 aruid) NN_NOEXCEPT;
        nn::Result CheckAruid2(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        void OpenSessionChar(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, nn::sf::Out<char> pCharOut, char x) NN_NOEXCEPT;
        std::uint32_t GetInlineContextTest() NN_NOEXCEPT;
        std::uint8_t GetFsInlineContextTest() NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    int EchoInt(int x) NN_NOEXCEPT;
    nn::Result StoreIntWithResult(int x) NN_NOEXCEPT;
    void StoreInt(int x) NN_NOEXCEPT;
    int LoadInt() NN_NOEXCEPT;
    void FlipBits(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
    std::int32_t Add(nnt::testsf::AddParameter p) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    void LoadIntByOut(nn::sf::Out<int> pOut) NN_NOEXCEPT;
    nnt::testsf::Struct2 EchoStruct(const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    void EchoStruct2(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    nn::sf::SharedPointer<nnt::testsf::ITestSession> OpenSession(int value) NN_NOEXCEPT;
    void OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, int value) NN_NOEXCEPT;
    int GetSessionCount() NN_NOEXCEPT;
    void GetNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    void MoveNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    void InNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT;
    void MoveInNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT;
    void SetClientProcessId(nn::Bit64 pid) NN_NOEXCEPT;
    void GetClientProcessId(nn::sf::Out<nn::Bit64> pOut) NN_NOEXCEPT;
    void SquareArrayElement(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT;
    void EchoStruct3(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    void MoveNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    bool EchoBool(bool x) NN_NOEXCEPT;
    std::uint16_t EchoUInt16(std::uint16_t x) NN_NOEXCEPT;
    std::uint64_t EchoUInt64(std::uint64_t x) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes2(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    void SquareArrayElement2(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT;
    void EchoStruct4(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    nn::Result DeferProcess() NN_NOEXCEPT;
    nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests> GetNullObject() NN_NOEXCEPT;
    void GetNullObject2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests>> pOut) NN_NOEXCEPT;
    nn::Result CauseError(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes3(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes4(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    nn::Result CheckAruid(nn::Bit64 aruid) NN_NOEXCEPT;
    nn::Result CheckAruid2(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    void OpenSessionChar(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, nn::sf::Out<char> pCharOut, char x) NN_NOEXCEPT;
    std::uint32_t GetInlineContextTest() NN_NOEXCEPT;
    std::uint8_t GetFsInlineContextTest() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nnt::testsf::IAllFunctionTestsBase), (::nnt::testsf::IAllFunctionTestsBase0))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(Add, (::std::int32_t), (::nnt::testsf::AddParameter p))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(Add, (::std::int32_t), (p));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(SumAndSubBytes, (::std::int32_t), (outSum, outSub, inBuffer1, inBuffer2));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(LoadIntByOut, (::nn::sf::Out<int> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(LoadIntByOut, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoStruct, (::nnt::testsf::Struct2), (const ::nnt::testsf::Struct1& s))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(EchoStruct, (::nnt::testsf::Struct2), (s));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EchoStruct2, (::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(EchoStruct2, (pOut, s));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(OpenSession, (::nn::sf::SharedPointer<::nnt::testsf::ITestSession>), (int value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(OpenSession, (::nn::sf::SharedPointer<::nnt::testsf::ITestSession>), (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(OpenSession2, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::ITestSession>> pOut, int value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(OpenSession2, (pOut, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetSessionCount, (int))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetSessionCount, (int));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetNativeHandle2, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetNativeHandle2, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(MoveNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(MoveNativeHandle, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(InNativeHandle, (::nn::sf::NativeHandle&& e))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(InNativeHandle, (::std::move(e)));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(MoveInNativeHandle, (::nn::sf::NativeHandle&& e))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(MoveInNativeHandle, (::std::move(e)));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetClientProcessId, (::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SetClientProcessId, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetClientProcessId, (::nn::sf::Out<::nn::Bit64> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetClientProcessId, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SquareArrayElement, (const ::nn::sf::OutArray<::std::int32_t>& dst, const ::nn::sf::InArray<::std::int32_t>& src))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SquareArrayElement, (dst, src));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EchoStruct3, (::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(EchoStruct3, (pOut, s));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(MoveNativeHandle2, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(MoveNativeHandle2, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoBool, (bool), (bool x))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(EchoBool, (bool), (x));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoUInt16, (::std::uint16_t), (::std::uint16_t x))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(EchoUInt16, (::std::uint16_t), (x));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoUInt64, (::std::uint64_t), (::std::uint64_t x))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(EchoUInt64, (::std::uint64_t), (x));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes2, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(SumAndSubBytes2, (::std::int32_t), (outSum, outSub, inBuffer1, inBuffer2));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SquareArrayElement2, (const ::nn::sf::OutArray<::std::int32_t>& dst, const ::nn::sf::InArray<::std::int32_t>& src))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(SquareArrayElement2, (dst, src));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EchoStruct4, (::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(EchoStruct4, (pOut, s));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeferProcess)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeferProcess);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetNullObject, (::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetNullObject, (::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetNullObject2, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(GetNullObject2, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CauseError, (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CauseError, (outSum, outSub, inBuffer1, inBuffer2));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes3, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(SumAndSubBytes3, (::std::int32_t), (outSum, outSub, inBuffer1, inBuffer2));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes4, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(SumAndSubBytes4, (::std::int32_t), (outSum, outSub, inBuffer1, inBuffer2));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckAruid, (::nn::Bit64 aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckAruid, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckAruid2, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckAruid2, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(OpenSessionChar, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::ITestSession>> pOut, ::nn::sf::Out<char> pCharOut, char x))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(OpenSessionChar, (pOut, pCharOut, x));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetInlineContextTest, (::std::uint32_t))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetInlineContextTest, (::std::uint32_t));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetFsInlineContextTest, (::std::uint8_t))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetFsInlineContextTest, (::std::uint8_t));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nnt::testsf::IAllFunctionTestsBase>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nnt::testsf::IAllFunctionTestsBase), (::nnt::testsf::IAllFunctionTestsBase0))

    // std::int32_t Add(nnt::testsf::AddParameter p) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Add)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(p, (::nnt::testsf::AddParameter), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (p))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(p)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Add)

    // std::int32_t SumAndSubBytes(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SumAndSubBytes)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSum, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSub, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer1, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer2, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (outSum, outSub, inBuffer1, inBuffer2))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSub), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer2)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SumAndSubBytes)

    // void LoadIntByOut(nn::sf::Out<int> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadIntByOut)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadIntByOut)

    // nnt::testsf::Struct2 EchoStruct(const nnt::testsf::Struct1& s) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EchoStruct)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(s, (::nnt::testsf::Struct1), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (s))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::nnt::testsf::Struct2), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(s)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EchoStruct)

    // void EchoStruct2(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EchoStruct2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(s, (::nnt::testsf::Struct1), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (s))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nnt::testsf::Struct2), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(s)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EchoStruct2)

    // nn::sf::SharedPointer<nnt::testsf::ITestSession> OpenSession(int value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSession)

    // void OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, int value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSession2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSession2)

    // int GetSessionCount() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSessionCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSessionCount)

    // void GetNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNativeHandle2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNativeHandle2)

    // void MoveNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(MoveNativeHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_MOVE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(MoveNativeHandle)

    // void InNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InNativeHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(e, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (e))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(e)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InNativeHandle)

    // void MoveInNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(MoveInNativeHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(e, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_MOVE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (e))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(e)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(MoveInNativeHandle)

    // void SetClientProcessId(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetClientProcessId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetClientProcessId)

    // void GetClientProcessId(nn::sf::Out<nn::Bit64> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetClientProcessId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetClientProcessId)

    // void SquareArrayElement(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SquareArrayElement)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dst, 0, (const ::nn::sf::OutArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(src, 1, (const ::nn::sf::InArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (dst, src))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dst), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(src)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SquareArrayElement)

    // void EchoStruct3(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EchoStruct3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nnt::testsf::Struct2>), 48, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(s, 1, (const ::nnt::testsf::Struct1&), 40, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOut, s))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(s)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EchoStruct3)

    // void MoveNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(MoveNativeHandle2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_MOVE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(MoveNativeHandle2)

    // bool EchoBool(bool x) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EchoBool)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (x))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EchoBool)

    // std::uint16_t EchoUInt16(std::uint16_t x) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EchoUInt16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (x))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EchoUInt16)

    // std::uint64_t EchoUInt64(std::uint64_t x) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EchoUInt64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (x))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EchoUInt64)

    // std::int32_t SumAndSubBytes2(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SumAndSubBytes2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSum, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSub, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer1, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer2, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (outSum, outSub, inBuffer1, inBuffer2))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSub), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer2)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SumAndSubBytes2)

    // void SquareArrayElement2(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SquareArrayElement2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(dst, 0, (const ::nn::sf::OutArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(src, 1, (const ::nn::sf::InArray<::std::int32_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (dst, src))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dst), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(src)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SquareArrayElement2)

    // void EchoStruct4(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EchoStruct4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nnt::testsf::Struct2>), 48, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(s, 1, (const ::nnt::testsf::Struct1&), 40, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOut, s))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(s)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EchoStruct4)

    // nn::Result DeferProcess() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeferProcess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeferProcess)

    // nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests> GetNullObject() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNullObject)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNullObject)

    // void GetNullObject2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNullObject2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNullObject2)

    // nn::Result CauseError(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CauseError)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSum, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSub, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer1, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer2, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (outSum, outSub, inBuffer1, inBuffer2))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSub), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer2)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CauseError)

    // std::int32_t SumAndSubBytes3(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SumAndSubBytes3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSum, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSub, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer1, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer2, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (outSum, outSub, inBuffer1, inBuffer2))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSub), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer2)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SumAndSubBytes3)

    // std::int32_t SumAndSubBytes4(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SumAndSubBytes4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSum, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outSub, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer1, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer2, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (outSum, outSub, inBuffer1, inBuffer2))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSub), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer2)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SumAndSubBytes4)

    // nn::Result CheckAruid(nn::Bit64 aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckAruid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckAruid)

    // nn::Result CheckAruid2(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckAruid2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckAruid2)

    // void OpenSessionChar(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, nn::sf::Out<char> pCharOut, char x) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSessionChar)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (char), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (x))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pCharOut, (char), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pCharOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pCharOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSessionChar)

    // std::uint32_t GetInlineContextTest() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInlineContextTest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(38)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInlineContextTest)

    // std::uint8_t GetFsInlineContextTest() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFsInlineContextTest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(39)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFsInlineContextTest)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nnt::testsf::AddParameter), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nnt::testsf::Struct2), 48, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nnt::testsf::Struct1), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nnt::testsf::IAllFunctionTestsBase, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nnt::testsf::IAllFunctionTestsBase), (::nnt::testsf::IAllFunctionTestsBase0))

    // std::int32_t Add(nnt::testsf::AddParameter p) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(Add, (::std::int32_t), (::nnt::testsf::AddParameter p))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Add)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(p)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Add)
    }

    // std::int32_t SumAndSubBytes(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SumAndSubBytes)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSub)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer2)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SumAndSubBytes)
    }

    // void LoadIntByOut(nn::sf::Out<int> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(LoadIntByOut, (::nn::sf::Out<int> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadIntByOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadIntByOut)
    }

    // nnt::testsf::Struct2 EchoStruct(const nnt::testsf::Struct1& s) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoStruct, (::nnt::testsf::Struct2), (const ::nnt::testsf::Struct1& s))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EchoStruct)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(s)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EchoStruct)
    }

    // void EchoStruct2(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EchoStruct2, (::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EchoStruct2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(s)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EchoStruct2)
    }

    // nn::sf::SharedPointer<nnt::testsf::ITestSession> OpenSession(int value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(OpenSession, (::nn::sf::SharedPointer<::nnt::testsf::ITestSession>), (int value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSession)
    }

    // void OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, int value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(OpenSession2, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::ITestSession>> pOut, int value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSession2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSession2)
    }

    // int GetSessionCount() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetSessionCount, (int))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSessionCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSessionCount)
    }

    // void GetNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetNativeHandle2, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNativeHandle2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNativeHandle2)
    }

    // void MoveNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(MoveNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(MoveNativeHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(MoveNativeHandle)
    }

    // void InNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(InNativeHandle, (::nn::sf::NativeHandle&& e))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InNativeHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(e)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InNativeHandle)
    }

    // void MoveInNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(MoveInNativeHandle, (::nn::sf::NativeHandle&& e))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(MoveInNativeHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(e)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(MoveInNativeHandle)
    }

    // void SetClientProcessId(nn::Bit64 pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SetClientProcessId, (::nn::Bit64 pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetClientProcessId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetClientProcessId)
    }

    // void GetClientProcessId(nn::sf::Out<nn::Bit64> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetClientProcessId, (::nn::sf::Out<::nn::Bit64> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetClientProcessId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetClientProcessId)
    }

    // void SquareArrayElement(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SquareArrayElement, (const ::nn::sf::OutArray<::std::int32_t>& dst, const ::nn::sf::InArray<::std::int32_t>& src))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SquareArrayElement)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dst)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(src)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SquareArrayElement)
    }

    // void EchoStruct3(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EchoStruct3, (::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EchoStruct3)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(s)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EchoStruct3)
    }

    // void MoveNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(MoveNativeHandle2, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(MoveNativeHandle2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(MoveNativeHandle2)
    }

    // bool EchoBool(bool x) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoBool, (bool), (bool x))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EchoBool)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EchoBool)
    }

    // std::uint16_t EchoUInt16(std::uint16_t x) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoUInt16, (::std::uint16_t), (::std::uint16_t x))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EchoUInt16)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EchoUInt16)
    }

    // std::uint64_t EchoUInt64(std::uint64_t x) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoUInt64, (::std::uint64_t), (::std::uint64_t x))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EchoUInt64)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EchoUInt64)
    }

    // std::int32_t SumAndSubBytes2(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes2, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SumAndSubBytes2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSub)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer2)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SumAndSubBytes2)
    }

    // void SquareArrayElement2(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(SquareArrayElement2, (const ::nn::sf::OutArray<::std::int32_t>& dst, const ::nn::sf::InArray<::std::int32_t>& src))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SquareArrayElement2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dst)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(src)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SquareArrayElement2)
    }

    // void EchoStruct4(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EchoStruct4, (::nn::sf::Out<::nnt::testsf::Struct2> pOut, const ::nnt::testsf::Struct1& s))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EchoStruct4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(s)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EchoStruct4)
    }

    // nn::Result DeferProcess() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeferProcess)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeferProcess)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeferProcess)
    }

    // nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests> GetNullObject() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetNullObject, (::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNullObject)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNullObject)
    }

    // void GetNullObject2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(GetNullObject2, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNullObject2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNullObject2)
    }

    // nn::Result CauseError(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CauseError, (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CauseError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSub)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer2)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CauseError)
    }

    // std::int32_t SumAndSubBytes3(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes3, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SumAndSubBytes3)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSub)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer2)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SumAndSubBytes3)
    }

    // std::int32_t SumAndSubBytes4(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(SumAndSubBytes4, (::std::int32_t), (const ::nn::sf::OutBuffer& outSum, const ::nn::sf::OutBuffer& outSub, const ::nn::sf::InBuffer& inBuffer1, const ::nn::sf::InBuffer& inBuffer2))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SumAndSubBytes4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSub)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer2)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SumAndSubBytes4)
    }

    // nn::Result CheckAruid(nn::Bit64 aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckAruid, (::nn::Bit64 aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckAruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckAruid)
    }

    // nn::Result CheckAruid2(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckAruid2, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckAruid2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckAruid2)
    }

    // void OpenSessionChar(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, nn::sf::Out<char> pCharOut, char x) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(OpenSessionChar, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::testsf::ITestSession>> pOut, ::nn::sf::Out<char> pCharOut, char x))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSessionChar)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pCharOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSessionChar)
    }

    // std::uint32_t GetInlineContextTest() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetInlineContextTest, (::std::uint32_t))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInlineContextTest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInlineContextTest)
    }

    // std::uint8_t GetFsInlineContextTest() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetFsInlineContextTest, (::std::uint8_t))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFsInlineContextTest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFsInlineContextTest)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nnt::testsf::IAllFunctionTestsBase>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nnt::testsf::IAllFunctionTestsBase), (::nnt::testsf::IAllFunctionTestsBase0))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Add)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Add)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(p)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SumAndSubBytes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSum)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSub)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer1)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SumAndSubBytes)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSub),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadIntByOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadIntByOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EchoStruct)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EchoStruct)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(s)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EchoStruct2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EchoStruct2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(s)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nnt::testsf::ITestSession>), NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(NN_SF_DETAIL_OUT_RETURN_NAME, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSession2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nnt::testsf::ITestSession>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSession2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSessionCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSessionCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNativeHandle2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNativeHandle2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(MoveNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(MoveNativeHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(e)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InNativeHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(e)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(MoveInNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(e)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(MoveInNativeHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(e)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetClientProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetClientProcessId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetClientProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetClientProcessId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SquareArrayElement)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dst)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(src)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SquareArrayElement)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dst),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(src)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EchoStruct3)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(s)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EchoStruct3)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(s)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(MoveNativeHandle2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(MoveNativeHandle2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EchoBool)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EchoBool)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EchoUInt16)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EchoUInt16)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EchoUInt64)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EchoUInt64)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SumAndSubBytes2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSum)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSub)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer1)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SumAndSubBytes2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSub),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SquareArrayElement2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dst)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(src)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SquareArrayElement2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dst),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(src)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EchoStruct4)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(s)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EchoStruct4)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(s)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeferProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeferProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNullObject)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>), NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNullObject)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(NN_SF_DETAIL_OUT_RETURN_NAME, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNullObject2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nnt::testsf::IAllFunctionTests>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNullObject2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CauseError)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSum)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSub)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer1)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CauseError)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSub),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SumAndSubBytes3)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSum)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSub)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer1)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SumAndSubBytes3)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSub),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SumAndSubBytes4)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSum)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSub)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer1)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SumAndSubBytes4)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSub),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckAruid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckAruid2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckAruid2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSessionChar)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nnt::testsf::ITestSession>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSessionChar)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pCharOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInlineContextTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInlineContextTest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFsInlineContextTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFsInlineContextTest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Add)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SumAndSubBytes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadIntByOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EchoStruct)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EchoStruct2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSession2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSessionCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNativeHandle2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(MoveNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(MoveInNativeHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetClientProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetClientProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SquareArrayElement)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EchoStruct3)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(MoveNativeHandle2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EchoBool)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EchoUInt16)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EchoUInt64)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SumAndSubBytes2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SquareArrayElement2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EchoStruct4)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeferProcess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNullObject)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNullObject2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CauseError)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SumAndSubBytes3)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SumAndSubBytes4)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckAruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckAruid2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSessionChar)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInlineContextTest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFsInlineContextTest)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nnt::testsf::IAllFunctionTestsBase))

namespace nnt { namespace testsf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAllFunctionTests, (::nnt::testsf::IAllFunctionTestsBase))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAllFunctionTests)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(EchoIntInherited, (int), (int x))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAllFunctionTests)

        int EchoIntInherited(int x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(EchoIntInherited, (int), (x));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAllFunctionTests : public ::nnt::testsf::IAllFunctionTestsBase
    {
    public:
        int EchoIntInherited(int x) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    int EchoInt(int x) NN_NOEXCEPT;
    nn::Result StoreIntWithResult(int x) NN_NOEXCEPT;
    void StoreInt(int x) NN_NOEXCEPT;
    int LoadInt() NN_NOEXCEPT;
    void FlipBits(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
    std::int32_t Add(nnt::testsf::AddParameter p) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    void LoadIntByOut(nn::sf::Out<int> pOut) NN_NOEXCEPT;
    nnt::testsf::Struct2 EchoStruct(const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    void EchoStruct2(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    nn::sf::SharedPointer<nnt::testsf::ITestSession> OpenSession(int value) NN_NOEXCEPT;
    void OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, int value) NN_NOEXCEPT;
    int GetSessionCount() NN_NOEXCEPT;
    void GetNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    void MoveNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    void InNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT;
    void MoveInNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT;
    void SetClientProcessId(nn::Bit64 pid) NN_NOEXCEPT;
    void GetClientProcessId(nn::sf::Out<nn::Bit64> pOut) NN_NOEXCEPT;
    void SquareArrayElement(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT;
    void EchoStruct3(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    void MoveNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    bool EchoBool(bool x) NN_NOEXCEPT;
    std::uint16_t EchoUInt16(std::uint16_t x) NN_NOEXCEPT;
    std::uint64_t EchoUInt64(std::uint64_t x) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes2(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    void SquareArrayElement2(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT;
    void EchoStruct4(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    nn::Result DeferProcess() NN_NOEXCEPT;
    nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests> GetNullObject() NN_NOEXCEPT;
    void GetNullObject2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests>> pOut) NN_NOEXCEPT;
    nn::Result CauseError(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes3(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes4(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    nn::Result CheckAruid(nn::Bit64 aruid) NN_NOEXCEPT;
    nn::Result CheckAruid2(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    void OpenSessionChar(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, nn::sf::Out<char> pCharOut, char x) NN_NOEXCEPT;
    std::uint32_t GetInlineContextTest() NN_NOEXCEPT;
    std::uint8_t GetFsInlineContextTest() NN_NOEXCEPT;
    int EchoIntInherited(int x) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nnt::testsf::IAllFunctionTests), (::nnt::testsf::IAllFunctionTestsBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoIntInherited, (int), (int x))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(EchoIntInherited, (int), (x));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nnt::testsf::IAllFunctionTests>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nnt::testsf::IAllFunctionTests), (::nnt::testsf::IAllFunctionTestsBase))

    // int EchoIntInherited(int x) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EchoIntInherited)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3000)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(x, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (x))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(x)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EchoIntInherited)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nnt::testsf::AddParameter), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nnt::testsf::Struct2), 48, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nnt::testsf::Struct1), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nnt::testsf::IAllFunctionTests, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nnt::testsf::IAllFunctionTests), (::nnt::testsf::IAllFunctionTestsBase))

    // int EchoIntInherited(int x) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(EchoIntInherited, (int), (int x))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EchoIntInherited)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(x)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EchoIntInherited)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nnt::testsf::IAllFunctionTests>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nnt::testsf::IAllFunctionTests), (::nnt::testsf::IAllFunctionTestsBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EchoIntInherited)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EchoIntInherited)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(x)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EchoIntInherited)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nnt::testsf::IAllFunctionTests))

namespace nnt { namespace testsf { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ITestSession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ITestSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetValue, (int))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ITestSession)

        int GetValue() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetValue, (int));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ITestSession
    {
    public:
        int GetValue() NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    int GetValue() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nnt::testsf::ITestSession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetValue, (int))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetValue, (int));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nnt::testsf::ITestSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nnt::testsf::ITestSession))

    // int GetValue() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (int), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetValue)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nnt::testsf::ITestSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nnt::testsf::ITestSession))

    // int GetValue() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetValue, (int))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetValue)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nnt::testsf::ITestSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nnt::testsf::ITestSession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetValue)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nnt::testsf::ITestSession))
