﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/settings/system/settings_SixAxisSensor.h>

//!< ConsoleSixAxisSensorAccelerationBias を変更可能か
TEST(SixAxisSensorSuite, ConsoleSixAxisSensorAccelerationBiasTest1)
{
    //!< TODO: テスト用キャリブレーション情報 A
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias
        ConsoleSixAxisSensorAccelerationBiasA =
    {
        1.f,
        1.f,
        1.f,
    };

    //!< TODO: テスト用キャリブレーション情報 B
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias
        ConsoleSixAxisSensorAccelerationBiasB =
    {
        2.f,
        2.f,
        2.f,
    };

    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias* pValues[] = {
        &ConsoleSixAxisSensorAccelerationBiasA,
        &ConsoleSixAxisSensorAccelerationBiasB,
    };

    for (const auto& pValue : pValues)
    {
        ::nn::settings::system::SetConsoleSixAxisSensorAccelerationBias(*pValue);

        ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias value;
        ::nn::settings::system::GetConsoleSixAxisSensorAccelerationBias(&value);

        EXPECT_EQ(pValue->x, value.x);
        EXPECT_EQ(pValue->y, value.y);
        EXPECT_EQ(pValue->z, value.z);
    }
}

//!< ConsoleSixAxisSensorAngularVelocityBias を変更可能か
TEST(SixAxisSensorSuite, ConsoleSixAxisSensorAngularVelocityBiasTest1)
{
    //!< TODO: テスト用キャリブレーション情報 A
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias
        ConsoleSixAxisSensorAngularVelocityBiasA =
    {
        1.f,
        1.f,
        1.f,
    };

    //!< TODO: テスト用キャリブレーション情報 B
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias
        ConsoleSixAxisSensorAngularVelocityBiasB =
    {
        2.f,
        2.f,
        2.f,
    };

    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias* pValues[] = {
        &ConsoleSixAxisSensorAngularVelocityBiasA,
        &ConsoleSixAxisSensorAngularVelocityBiasB,
    };

    for (const auto& pValue : pValues)
    {
        ::nn::settings::system::SetConsoleSixAxisSensorAngularVelocityBias(*pValue);

        ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias value;
        ::nn::settings::system::GetConsoleSixAxisSensorAngularVelocityBias(&value);

        EXPECT_EQ(pValue->x, value.x);
        EXPECT_EQ(pValue->y, value.y);
        EXPECT_EQ(pValue->z, value.z);
    }
}

//!< ConsoleSixAxisSensorAccelerationGain を変更可能か
TEST(SixAxisSensorSuite, ConsoleSixAxisSensorAccelerationGainTest1)
{
    //!< TODO: テスト用キャリブレーション情報 A
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain
        ConsoleSixAxisSensorAccelerationGainA =
    {
        1.f, 1.f, 1.f,
        1.f, 1.f, 1.f,
        1.f, 1.f, 1.f,
    };

    //!< TODO: テスト用キャリブレーション情報 B
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain
        ConsoleSixAxisSensorAccelerationGainB =
    {
        .1f, .1f, .1f,
        .1f, .1f, .1f,
        .1f, .1f, .1f,
    };

    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain* pValues[] = {
        &ConsoleSixAxisSensorAccelerationGainA,
        &ConsoleSixAxisSensorAccelerationGainB,
    };

    for (const auto& pValue : pValues)
    {
        ::nn::settings::system::SetConsoleSixAxisSensorAccelerationGain(*pValue);

        ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain value;
        ::nn::settings::system::GetConsoleSixAxisSensorAccelerationGain(&value);

        EXPECT_EQ(pValue->xx, value.xx);
        EXPECT_EQ(pValue->xy, value.xy);
        EXPECT_EQ(pValue->xz, value.xz);

        EXPECT_EQ(pValue->yx, value.yx);
        EXPECT_EQ(pValue->yy, value.yy);
        EXPECT_EQ(pValue->yz, value.yz);

        EXPECT_EQ(pValue->zx, value.zx);
        EXPECT_EQ(pValue->zy, value.zy);
        EXPECT_EQ(pValue->zz, value.zz);
    }
}

//!< ConsoleSixAxisSensorAngularVelocityGain を変更可能か
TEST(SixAxisSensorSuite, ConsoleSixAxisSensorAngularVelocityGainTest1)
{
    //!< TODO: テスト用キャリブレーション情報 A
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain
        ConsoleSixAxisSensorAngularVelocityGainA =
    {
        1.f, 1.f, 1.f,
        1.f, 1.f, 1.f,
        1.f, 1.f, 1.f,
    };

    //!< TODO: テスト用キャリブレーション情報 B
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain
        ConsoleSixAxisSensorAngularVelocityGainB =
    {
        .1f, .1f, .1f,
        .1f, .1f, .1f,
        .1f, .1f, .1f,
    };

    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain* pValues[] = {
        &ConsoleSixAxisSensorAngularVelocityGainA,
        &ConsoleSixAxisSensorAngularVelocityGainB,
    };

    for (const auto& pValue : pValues)
    {
        ::nn::settings::system::SetConsoleSixAxisSensorAngularVelocityGain(*pValue);

        ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain value;
        ::nn::settings::system::GetConsoleSixAxisSensorAngularVelocityGain(&value);

        EXPECT_EQ(pValue->xx, value.xx);
        EXPECT_EQ(pValue->xy, value.xy);
        EXPECT_EQ(pValue->xz, value.xz);

        EXPECT_EQ(pValue->yx, value.yx);
        EXPECT_EQ(pValue->yy, value.yy);
        EXPECT_EQ(pValue->yz, value.yz);

        EXPECT_EQ(pValue->zx, value.zx);
        EXPECT_EQ(pValue->zy, value.zy);
        EXPECT_EQ(pValue->zz, value.zz);
    }
}

//!< ConsoleSixAxisSensorAngularVelocityTimeBias を変更可能か
TEST(SixAxisSensorSuite, ConsoleSixAxisSensorAngularVelocityTimeBiasTest1)
{
    //!< TODO: テスト用キャリブレーション情報 A
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias
        ConsoleSixAxisSensorAngularVelocityTimeBiasA =
    {
        1.f,
        1.f,
        1.f,
    };

    //!< TODO: テスト用キャリブレーション情報 B
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias
        ConsoleSixAxisSensorAngularVelocityTimeBiasB =
    {
        2.f,
        2.f,
        2.f,
    };

    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias* pValues[] = {
        &ConsoleSixAxisSensorAngularVelocityTimeBiasA,
        &ConsoleSixAxisSensorAngularVelocityTimeBiasB,
    };

    for (const auto& pValue : pValues)
    {
        ::nn::settings::system::SetConsoleSixAxisSensorAngularVelocityTimeBias(*pValue);

        ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias value;
        ::nn::settings::system::GetConsoleSixAxisSensorAngularVelocityTimeBias(&value);

        EXPECT_EQ(pValue->x, value.x);
        EXPECT_EQ(pValue->y, value.y);
        EXPECT_EQ(pValue->z, value.z);
    }
}

//!< ConsoleSixAxisSensorAngularAcceleration を変更可能か
TEST(SixAxisSensorSuite, ConsoleSixAxisSensorAngularAccelerationTest1)
{
    //!< TODO: テスト用キャリブレーション情報 A
    const ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration
        ConsoleSixAxisSensorAngularAccelerationA =
    {
        1.f, 1.f, 1.f,
        1.f, 1.f, 1.f,
        1.f, 1.f, 1.f,
    };

    //!< TODO: テスト用キャリブレーション情報 B
    const ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration
        ConsoleSixAxisSensorAngularAccelerationB =
    {
        .1f, .1f, .1f,
        .1f, .1f, .1f,
        .1f, .1f, .1f,
    };

    const ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration* pValues[] = {
        &ConsoleSixAxisSensorAngularAccelerationA,
        &ConsoleSixAxisSensorAngularAccelerationB,
    };

    for (const auto& pValue : pValues)
    {
        ::nn::settings::system::SetConsoleSixAxisSensorAngularAcceleration(*pValue);

        ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration value;
        ::nn::settings::system::GetConsoleSixAxisSensorAngularAcceleration(&value);

        EXPECT_EQ(pValue->xx, value.xx);
        EXPECT_EQ(pValue->xy, value.xy);
        EXPECT_EQ(pValue->xz, value.xz);

        EXPECT_EQ(pValue->yx, value.yx);
        EXPECT_EQ(pValue->yy, value.yy);
        EXPECT_EQ(pValue->yz, value.yz);

        EXPECT_EQ(pValue->zx, value.zx);
        EXPECT_EQ(pValue->zy, value.zy);
        EXPECT_EQ(pValue->zz, value.zz);
    }
}
