﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/system/settings_PushNotification.h>
#include <nnt/nntest.h>

//!< プッシュ通知のスリープ状態における動作モードを変更可能か
TEST(PushNotificationSuite, ActivityModeOnSleepTest1)
{
    const int32_t mode =
        ::nn::settings::system::GetPushNotificationActivityModeOnSleep();

    const int32_t modeA = 8;

    ::nn::settings::system::SetPushNotificationActivityModeOnSleep(modeA);

    EXPECT_EQ(
        modeA,
        ::nn::settings::system::GetPushNotificationActivityModeOnSleep());

    const int32_t modeB = 256;

    ::nn::settings::system::SetPushNotificationActivityModeOnSleep(modeB);

    EXPECT_EQ(
        modeB,
        ::nn::settings::system::GetPushNotificationActivityModeOnSleep());

    ::nn::settings::system::SetPushNotificationActivityModeOnSleep(mode);
}
