﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/settings/system/settings_Ldn.h>

//!< ローカル通信のチャンネルを取得可能か
TEST(LdnSuite, LdnChannelTest1)
{
    ::nn::settings::system::GetLdnChannel();
}

//!< ローカル通信のチャンネルを変更可能か
TEST(LdnSuite, LdnChannelTest2)
{
    int32_t value = ::nn::settings::system::GetLdnChannel();

    ::nn::settings::system::SetLdnChannel(1);

    EXPECT_EQ(1, ::nn::settings::system::GetLdnChannel());

    ::nn::settings::system::SetLdnChannel(2);

    EXPECT_EQ(2, ::nn::settings::system::GetLdnChannel());

    ::nn::settings::system::SetLdnChannel(value);
}
