﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/settings/system/settings_Backlight.h>
#include <nnt/nntest.h>

namespace {

//!< テスト用画面の明るさ設定 A
const ::nn::settings::system::BacklightSettings BacklightSettingsA = {
    { { 0 } },
    0.1f,
    { { { 0.2f, 0.3f, 0.4f } } },
    { { { 0.5f, 0.6f, 0.7f } } },
    0.8f,
    0.9f,
};

//!< テスト用画面の明るさ設定 B
const ::nn::settings::system::BacklightSettings BacklightSettingsB = {
    { { 1 } },
    0.9f,
    { { { 0.8f, 0.7f, 0.6f } } },
    { { { 0.5f, 0.4f, 0.3f } } },
    0.2f,
    0.1f,
};

//!< テスト用画面の明るさ設定 C
const ::nn::settings::system::BacklightSettingsEx BacklightSettingsC = {
    { { 0 } },
    0.1f,
    0.15f,
    { { { 0.2f, 0.3f, 0.4f } } },
    { { { 0.5f, 0.6f, 0.7f } } },
    0.8f,
    0.9f,
};

//!< テスト用画面の明るさ設定 D
const ::nn::settings::system::BacklightSettingsEx BacklightSettingsD = {
    { { 1 } },
    0.9f,
    0.25f,
    { { { 0.8f, 0.7f, 0.6f } } },
    { { { 0.5f, 0.4f, 0.3f } } },
    0.2f,
    0.1f,
};

} // namespace

//!< 画面の明るさ設定を設定可能か
TEST(BacklightSuite, BacklightSettingsTest1)
{
    ::nn::settings::system::BacklightSettings original = {};

    ::nn::settings::system::GetBacklightSettings(&original);

    ::nn::settings::system::SetBacklightSettings(BacklightSettingsA);

    ::nn::settings::system::SetBacklightSettings(BacklightSettingsB);

    ::nn::settings::system::BacklightSettings settings = {};

    ::nn::settings::system::GetBacklightSettings(&settings);

    EXPECT_EQ(
        BacklightSettingsB.flags.Test<
            ::nn::settings::system::BacklightFlag::Automatic>(),
        settings.flags.Test<
            ::nn::settings::system::BacklightFlag::Automatic>());

    EXPECT_FLOAT_EQ(BacklightSettingsB.brightness, settings.brightness);

    EXPECT_FLOAT_EQ(BacklightSettingsB.brightnessCoefficients.x,
                    settings.brightnessCoefficients.x);

    EXPECT_FLOAT_EQ(BacklightSettingsB.brightnessCoefficients.y,
                    settings.brightnessCoefficients.y);

    EXPECT_FLOAT_EQ(BacklightSettingsB.brightnessCoefficients.z,
                    settings.brightnessCoefficients.z);

    EXPECT_FLOAT_EQ(BacklightSettingsB.sensorCoefficients.x,
                    settings.sensorCoefficients.x);

    EXPECT_FLOAT_EQ(BacklightSettingsB.sensorCoefficients.y,
                    settings.sensorCoefficients.y);

    EXPECT_FLOAT_EQ(BacklightSettingsB.sensorCoefficients.z,
                    settings.sensorCoefficients.z);

    EXPECT_FLOAT_EQ(BacklightSettingsB.delayDarkToBright,
                    settings.delayDarkToBright);

    EXPECT_FLOAT_EQ(BacklightSettingsB.delayBrightToDark,
                    settings.delayBrightToDark);

    ::nn::settings::system::SetBacklightSettings(original);
}

//!< 画面の明るさ設定 (VR モード対応版) を設定可能か
TEST(BacklightSuite, BacklightSettingsTest2)
{
    ::nn::settings::system::BacklightSettingsEx original = {};

    ::nn::settings::system::GetBacklightSettings(&original);

    ::nn::settings::system::SetBacklightSettings(BacklightSettingsC);

    ::nn::settings::system::SetBacklightSettings(BacklightSettingsD);

    ::nn::settings::system::BacklightSettingsEx settings = {};

    ::nn::settings::system::GetBacklightSettings(&settings);

    EXPECT_EQ(
        BacklightSettingsD.flags.Test<
            ::nn::settings::system::BacklightFlag::Automatic>(),
        settings.flags.Test<
            ::nn::settings::system::BacklightFlag::Automatic>());

    EXPECT_FLOAT_EQ(BacklightSettingsD.brightness, settings.brightness);

    EXPECT_FLOAT_EQ(BacklightSettingsD.brightnessVr, settings.brightnessVr);

    EXPECT_FLOAT_EQ(BacklightSettingsD.brightnessCoefficients.x,
                    settings.brightnessCoefficients.x);

    EXPECT_FLOAT_EQ(BacklightSettingsD.brightnessCoefficients.y,
                    settings.brightnessCoefficients.y);

    EXPECT_FLOAT_EQ(BacklightSettingsD.brightnessCoefficients.z,
                    settings.brightnessCoefficients.z);

    EXPECT_FLOAT_EQ(BacklightSettingsD.sensorCoefficients.x,
                    settings.sensorCoefficients.x);

    EXPECT_FLOAT_EQ(BacklightSettingsD.sensorCoefficients.y,
                    settings.sensorCoefficients.y);

    EXPECT_FLOAT_EQ(BacklightSettingsD.sensorCoefficients.z,
                    settings.sensorCoefficients.z);

    EXPECT_FLOAT_EQ(BacklightSettingsD.delayDarkToBright,
                    settings.delayDarkToBright);

    EXPECT_FLOAT_EQ(BacklightSettingsD.delayBrightToDark,
                    settings.delayBrightToDark);

    ::nn::settings::system::SetBacklightSettings(original);
}

//!< 画面の明るさ設定のフォーマットバージョンの違いが正しく処理されるか
TEST(BacklightSuite, BacklightSettingsTest3)
{
    ::nn::settings::system::BacklightSettingsEx original = {};

    ::nn::settings::system::GetBacklightSettings(&original);

    ::nn::settings::system::SetBacklightSettings(BacklightSettingsC);

    ::nn::settings::system::SetBacklightSettings(BacklightSettingsA);

    ::nn::settings::system::BacklightSettingsEx settings = {};

    ::nn::settings::system::GetBacklightSettings(&settings);

    EXPECT_FLOAT_EQ(BacklightSettingsA.brightness, settings.brightness);

    EXPECT_FLOAT_EQ(BacklightSettingsC.brightnessVr, settings.brightnessVr);

    EXPECT_FLOAT_EQ(BacklightSettingsA.brightnessCoefficients.x,
                    settings.brightnessCoefficients.x);

    EXPECT_FLOAT_EQ(BacklightSettingsA.brightnessCoefficients.y,
                    settings.brightnessCoefficients.y);

    EXPECT_FLOAT_EQ(BacklightSettingsA.brightnessCoefficients.z,
                    settings.brightnessCoefficients.z);

    EXPECT_FLOAT_EQ(BacklightSettingsA.sensorCoefficients.x,
                    settings.sensorCoefficients.x);

    EXPECT_FLOAT_EQ(BacklightSettingsA.sensorCoefficients.y,
                    settings.sensorCoefficients.y);

    EXPECT_FLOAT_EQ(BacklightSettingsA.sensorCoefficients.z,
                    settings.sensorCoefficients.z);

    EXPECT_FLOAT_EQ(BacklightSettingsA.delayDarkToBright,
                    settings.delayDarkToBright);

    EXPECT_FLOAT_EQ(BacklightSettingsA.delayBrightToDark,
                    settings.delayBrightToDark);

    ::nn::settings::system::SetBacklightSettings(original);
}
