﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

namespace nnt { namespace settings { namespace fwdbg {

//!< ファイルシステムをマウントします。
void MountFileSystem() NN_NOEXCEPT;

//!< 設定のルートディレクトリを初期化します。
void InitializeSettingsRootDirectory() NN_NOEXCEPT;

//!< 設定と対応するディレクトリを作成します。
void CreateSettingsDirectory(const char* name) NN_NOEXCEPT;

//!< 設定項目と対応するファイルを作成します。
void CreateSettingsItemFile(const char* name,
                            const char* key,
                            const void* value,
                            size_t size) NN_NOEXCEPT;

}}} // namaspace nnt::settings::fwdbg
