﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstdio>
#include <cstring>
#include <cstdlib>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>

#include <nn/ssl.h>
#include <nn/ssl/ssl_Api.debug.h>
#include <nn/socket.h>

#include "ExecuterTestsBase.h"
#include "ExecuterTestsRunWithSingleHost.h"

// ------------------------------------------------------------------------------------------------
// ExecuterTestsRunWithSingleHost
// ------------------------------------------------------------------------------------------------
ExecuterTestsRunWithSingleHost::ExecuterTestsRunWithSingleHost(
    const char* pInHostName,
    nn::ssl::Connection::VerifyOption verifyOption,
    nn::ssl::Connection::SessionCacheMode sessionCacheMode,
    uint16_t port,
    uint32_t count)
{
    m_RunCount         = (count > 0)?count:1;
    m_VerifyOption     = verifyOption;
    m_SessionCacheMode = sessionCacheMode;

    if (pInHostName != nullptr)
    {
        strncpy(m_HostName, pInHostName, sizeof(m_HostName));
    }
    else
    {
        m_HostName[0] = '\0';
    }

    if (port != 0)
    {
        m_Port = port;
    }
    else
    {
        m_Port = 443;
    }
}

ExecuterTestsRunWithSingleHost::~ExecuterTestsRunWithSingleHost()
{
}

void ExecuterTestsRunWithSingleHost::Run()
{
    nn::Result result;

    nn::ssl::Debug::HeapTrackPoint tracker;
    StartHeapTrack(&tracker);

    do
    {
        if (m_HostName[0] == '\0')
        {
            NN_LOG(" [ERROR] No host name is set.\n");
            break;
        }

        for (uint32_t i = 0; i < m_RunCount; i++)
        {
            nn::ssl::Context*    pSslContext;
            nn::ssl::Connection* pSslConnection;

            pSslContext = new nn::ssl::Context();
            pSslConnection = new nn::ssl::Connection();

            result = ExecuterTestsBase::PerformHandshake(
                m_HostName,
                pSslContext,
                pSslConnection,
                m_Port,
                m_VerifyOption,
                m_SessionCacheMode,
                nn::ssl::Connection::IoMode_Blocking,
                false,
                false,
                false,
                false);

            delete pSslConnection;
            delete pSslContext;

            NN_LOG(" count: %d\n", i + 1);
            if (result.IsFailure())
            {
                break;
            }
        }

        ExecuterTestsBase::SetResult(result.IsSuccess());
    } while (NN_STATIC_CONDITION(false));

    EndHeapTrack(&tracker);
    ExecuterTestsBase::PrintResult();
}

