﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstdio>
#include <cstring>
#include <cstdlib>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/init.h>
#include <nn/os.h>

#include <nn/ssl.h>
#include <nn/ssl/ssl_Api.debug.h>
#include <nn/socket.h>

#include "ExecuterTestsBase.h"
#include "ExecuterTestsRunWithMultiHosts.h"


// ------------------------------------------------------------------------------------------------
// ExecuterTestsRunWithMultiHosts
// ------------------------------------------------------------------------------------------------
const char ExecuterTestsRunWithMultiHosts::TestHosts[][ExecuterTestsRunWithMultiHosts::HostNameLength] = {
    "www.facebook.com",
    "twitter.com",
    "www.yahoo.com",
    "www.linkedin.com",
    "www.microsoft.com",
    "www.nokia.com",
    "www.motorola.com",
    "www.ge.com",
    "www.siemens.com",
    "www.micron.com",
    "www.agilent.com",
    "www.qualcomm.com",
    "www.ti.com",
    "www.broadcom.com",
    "www.sandisk.com",
    "www.freescale.com",
    "www.amd.com",
    "www.apple.com",
    "www.xilinx.com",
    "www.forbes.com",
    "www.bloomberg.com",
    "www.whatsapp.com",
    "www.instagram.com",
    "www.skype.com",
    "www.snapchat.com",
    "www.amazon.com",
    "www.netflix.com",
    "www.meetup.com",
    "www.youtube.com",
    "www.ubisoft.com",
    "www.ea.com",
    "www.activision.com",
    "www.nintendo.com",
    "bethesda.net",
    "unity3d.com",
    "www.epicgames.com",
    "dena.com",
    "www.expedia.com",
    "www.hotels.com",
    "www.booking.com",
    "www.travelocity.com",
    "www.orbitz.com",
    "www.kayak.com",
    "www.tripadvisor.com",
    "www.united.com",
    "www.alaskaair.com",
    "www.aa.com",
    "www.southwest.com",
    "www.ana.co.jp",
    "www.jal.co.jp",
    "www.jetblue.com",
    "www.flyfrontier.com",
    "www.allegiantair.com",
};

ExecuterTestsRunWithMultiHosts::ExecuterTestsRunWithMultiHosts(
    nn::ssl::Connection::VerifyOption verifyOption,
    nn::ssl::Connection::SessionCacheMode sessionCacheMode,
    uint32_t count)
{
    m_RunCount         = (count > 0)?count:1;
    m_VerifyOption     = verifyOption;
    m_SessionCacheMode = sessionCacheMode;
}

ExecuterTestsRunWithMultiHosts::~ExecuterTestsRunWithMultiHosts()
{
}

void ExecuterTestsRunWithMultiHosts::Run()
{
    nn::Result result;
    size_t     testUrlCount = sizeof(TestHosts) / sizeof(TestHosts[0]);

    nn::ssl::Debug::HeapTrackPoint tracker;
    StartHeapTrack(&tracker);
    do
    {
        for (uint32_t i = 0; i < m_RunCount; i++)
        {
            for (uint32_t j = 0; j < testUrlCount; j++)
            {
                nn::ssl::Context*    pSslContext;
                nn::ssl::Connection* pSslConnection;

                pSslContext = new nn::ssl::Context();
                pSslConnection = new nn::ssl::Connection();

                result = ExecuterTestsBase::PerformHandshake(
                    TestHosts[j],
                    pSslContext,
                    pSslConnection,
                    TestPortNumber,
                    m_VerifyOption,
                    m_SessionCacheMode,
                    nn::ssl::Connection::IoMode_Blocking,
                    false,
                    false,
                    false,
                    false);

                delete pSslConnection;
                delete pSslContext;

                NN_LOG(" count: %d\n", j + 1);
                if (result.IsFailure())
                {
                    TEST_CASE_VERBOSE_LOG(" Failed with %s\n", TestHosts[j]);
                    break;
                }
            }

            if (result.IsFailure())
            {
                break;
            }
        }

        ExecuterTestsBase::SetResult(result.IsSuccess());
    } while (NN_STATIC_CONDITION(false));

    EndHeapTrack(&tracker);
    ExecuterTestsBase::PrintResult();
}

