﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

const char g_pTestRootCaCert[] = "-----BEGIN CERTIFICATE-----\nMIIDxjCCAq6gAwIBAgIBATANBgkqhkiG9w0BAQUFADB0MRMwEQYKCZImiZPyLGQB\nGRYDb3JnMRYwFAYKCZImiZPyLGQBGRYGc2ltcGxlMRMwEQYDVQQKDApTaW1wbGUg\nSW5jMRcwFQYDVQQLDA5TaW1wbGUgUm9vdCBDQTEXMBUGA1UEAwwOU2ltcGxlIFJv\nb3QgQ0EwHhcNMTYwMTI1MjMyMDUzWhcNMjYwMTI0MjMyMDUzWjB0MRMwEQYKCZIm\niZPyLGQBGRYDb3JnMRYwFAYKCZImiZPyLGQBGRYGc2ltcGxlMRMwEQYDVQQKDApT\naW1wbGUgSW5jMRcwFQYDVQQLDA5TaW1wbGUgUm9vdCBDQTEXMBUGA1UEAwwOU2lt\ncGxlIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDbGJ7D\nPUPg2tfkfTVzpp5LHywQYWHZoDCLc17mnScgy96FTmLFoAeMeV+H2fv1frjdgDOf\nxdIw8EzyqQR2+HojB31ue2DbGUDfxLWSMMIHYzYyj/NhRpnVYJg2aTCwW0a8jZpd\nf6bSerE/lE+spkflcZCWxedKNvgLVvkqIUZc1H0IgXn/78xzSpp7CTQUizlmLbi/\n59eiqmUyUlza3gB1akcLCNx/FCxgRxe3wZl4LuiLJLwxCFQU/txRs5PmK1NG0Mta\ncjGyziXgUTkeCVyyoOawd//uIIY0JN2ddWzEmkN+ZIOQu9FjdgoCHBBd3+PEhPSP\ngg//eIYoQDQg26i9AgMBAAGjYzBhMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8E\nBTADAQH/MB0GA1UdDgQWBBQuBiXYkKDZwZJnQG0xEYgTZYhZ6zAfBgNVHSMEGDAW\ngBQuBiXYkKDZwZJnQG0xEYgTZYhZ6zANBgkqhkiG9w0BAQUFAAOCAQEAcKFP1oJM\nLNYdAtmufqcN4OJBBSTjoLXLiLddauFQdwctf7luDW06KG+d/qHDDZj0hkjtjVX5\n6NAFgnSVBxrp86sDj3e1cDZ12xGijOFb/R4H2mhsw1Sdj3rULySJn7BF2jXyC1v3\nH6fvBLlh/oRavtExX++xpQ/fDhAZpUHyaeI/w+XD8EGd3C7WN1W7oPHXiuhnkbi3\nQc9u96ZuMQhfsZGBtQ5NGDYSAM2cyqL5H5s21+ulqfgZvnEawF1xHLLEIUpFdXRP\nFAVIo6N0ZVaqOfoVgmRI39u90TbIfHMGcMa37VwuXelUKHIGgviFK7kkPWNWZUsF\noXPjc2Bidlg47Q==\n-----END CERTIFICATE-----";
const char g_pTestSigningCaCert[] = "-----BEGIN CERTIFICATE-----\nMIIDzzCCAregAwIBAgIBAjANBgkqhkiG9w0BAQUFADB0MRMwEQYKCZImiZPyLGQB\nGRYDb3JnMRYwFAYKCZImiZPyLGQBGRYGc2ltcGxlMRMwEQYDVQQKDApTaW1wbGUg\nSW5jMRcwFQYDVQQLDA5TaW1wbGUgUm9vdCBDQTEXMBUGA1UEAwwOU2ltcGxlIFJv\nb3QgQ0EwHhcNMTYwMTI1MjMyMzM0WhcNMjYwMTI0MjMyMzM0WjB6MRMwEQYKCZIm\niZPyLGQBGRYDb3JnMRYwFAYKCZImiZPyLGQBGRYGc2ltcGxlMRMwEQYDVQQKDApT\naW1wbGUgSW5jMRowGAYDVQQLDBFTaW1wbGUgU2lnbmluZyBDQTEaMBgGA1UEAwwR\nU2ltcGxlIFNpZ25pbmcgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQDkPKW4Jsc4jNaQCpnwueRFx+N4geIpeJSVSGwwKaafbjUws+kQ1H2XIBUZhWjH\noE5AUewtZ0xhu9bZzsA3Am/ixIKmm2BWn9aNyT06ZoVqbKchHw55nxUvchsed5qe\nrX4BG7pQY7A74+4AFYG0bpwITSegqfM3hvJwyXOTYhG+a3ADkHR6nvaRQ0ZI8W68\nWv3IsuLdHXC/GlQst5a7wSZxVJ+uPedbTC69q/zWVT2noLuo4nCmZNameaOZT29h\nqKvx/FA56YETYeSkv+cuM+gvm1DhWLsxwN4wjQJjAwbF4Pn3ROnqo3QhsRUIuVvj\nPXw+XQDRUWhWuZojtuuJ/44jAgMBAAGjZjBkMA4GA1UdDwEB/wQEAwIBBjASBgNV\nHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBQwCQMWflotKdKVfQ5r6dfjpzppDTAf\nBgNVHSMEGDAWgBQuBiXYkKDZwZJnQG0xEYgTZYhZ6zANBgkqhkiG9w0BAQUFAAOC\nAQEArVbGREYwEbAFKNZnh6G+ujq6VQ4KjnpU6swnwN6bHLHqVA7f+44bB0ou3w6g\n6Fs7S3SmHoM2oWXXE75HzcSprHRFvIGNQiXp7g3xlvMVVkk2kZ2rl9ior4xhfT5L\n8+7yNwlUeDlqUj2xRmMkiDe9d6ixdCWbJX6Af8BvvcO6GS7H8SGAK7/3RhH1D9Dp\nFF1RsBqVu21hU3FOe7sxDnmSGx6WxS0QC+CIN0Z4mtWofjYygGdtmngwfdyu1tfh\nhr3CmUhmZvG78Kvm/K6Fm8RP6O01fm48M6eDOWKN8Yf3T0VyayqGDI+Bl8yX+KoR\nJrbppJnvKTjdgenH0MxI03iVzA==\n-----END CERTIFICATE-----";
const char g_pTestCaCert[] = "-----BEGIN CERTIFICATE-----\nMIIEOTCCAyGgAwIBAgIBATANBgkqhkiG9w0BAQUFADB6MRMwEQYKCZImiZPyLGQB\nGRYDb3JnMRYwFAYKCZImiZPyLGQBGRYGc2ltcGxlMRMwEQYDVQQKDApTaW1wbGUg\nSW5jMRowGAYDVQQLDBFTaW1wbGUgU2lnbmluZyBDQTEaMBgGA1UEAwwRU2ltcGxl\nIFNpZ25pbmcgQ0EwHhcNMTYwMTI1MjMyOTM2WhcNMTgwMTI0MjMyOTM2WjCBmDET\nMBEGCgmSJomT8ixkARkWA29yZzEWMBQGCgmSJomT8ixkARkWBnNpbXBsZTETMBEG\nA1UECgwKU2ltcGxlIEluYzEpMCcGA1UECwwgbnRkLW5ldC1zZXJ2ZXIxLm50ZC5u\naW50ZW5kby5jb20xKTAnBgNVBAMMIG50ZC1uZXQtc2VydmVyMS5udGQubmludGVu\nZG8uY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3qVVe6OeFuP8\n8ezCh/bZ02yCeS6wjM7yYaxlDETaE88//CsikUSlQFH+9mg1p8JcteG3KKeGJtla\nYehyZRHsbOraNXLUzdJb/6j9aMOxFPnlmBe9/flJFSM0NGly3UH70CtJPiBp5HyB\nH+/A/pyISdPBYkebdg0t8F2WNfO5A0/qOP3QxI5ro6k/dW0z9hMX1B2A+d5jtOkC\nmEHsnkgXp9SMDyCabM9qSECBZ6mqQVIZLg1HQA0xdIgaJ0tQvtqzcIxrQs/ZS09K\nCm5bBPPerQ9q+e6u8+UbO3UnwIuujhfO+1GzRMtC4J16mf6LdqycmNbUxn8sS8R8\nTK6QmhJHoQIDAQABo4GqMIGnMA4GA1UdDwEB/wQEAwIFoDAJBgNVHRMEAjAAMB0G\nA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUC0cFnuCaJXg/\nWU7Iotihbbv7Z3AwHwYDVR0jBBgwFoAUMAkDFn5aLSnSlX0Oa+nX46c6aQ0wKwYD\nVR0RBCQwIoIgbnRkLW5ldC1zZXJ2ZXIxLm50ZC5uaW50ZW5kby5jb20wDQYJKoZI\nhvcNAQEFBQADggEBAHgwuk87+eY2sz4DwlgghsLBkDFf0WZ+Hs05QaDCOP54C1QM\nnqU1djB448rhEo5OamhykZ/13VrhZwP7lsFYqrIG4QJCrJo4Z3d5gnG02bh08z/h\nWFHTqFNGCU5HFmG4amKoTB8VU6dlLE2aMNQnRVOrm02q4Q28mxKhynuHyE7E5vOy\nqziTQCULdO2/+ZLyKDsnUEdT/QZm5kTMjdynSrBgZ2/RPABMJOTL8yvNd3fdh33h\nyKXchj8O9AIse4DinQgEhfyh9N1K9FdK1JimvefYk3KtDxn+8Z/v6KdZ9ZD676gW\nCfpEoHxDcTOESAyxulRKp3nBRulL7zFO9OMSFnE=\n-----END CERTIFICATE-----";
const char g_pTestCaCert2[] = "-----BEGIN CERTIFICATE-----\nMIIDnDCCAoSgAwIBAgIJAKdXcsfUe46JMA0GCSqGSIb3DQEBCwUAMIGPMQswCQYD\nVQQGEwJVUzETMBEGA1UECAwKV2FzaGluZ3RvbjERMA8GA1UECgwITmludGVuZG8x\nLTArBgNVBAsMJE5pbnRlbmRvIFRlY2hub2xvZ3kgRGV2ZWxvcG1lbnQgSW5jLjEp\nMCcGA1UEAwwgbnRkLW5ldC1zZXJ2ZXIxLm50ZC5uaW50ZW5kby5jb20wHhcNMTYw\nNTAzMTgwNjQyWhcNMTcwNTAzMTgwNjQyWjCBkTELMAkGA1UEBhMCVVMxEzARBgNV\nBAgMCldhc2hpbmd0b24xETAPBgNVBAoMCE5pbnRlbmRvMS0wKwYDVQQLDCROaW50\nZW5kbyBUZWNobm9sb2d5IERldmVsb3BtZW50IEluYy4xKzApBgNVBAMMIm50ZC1u\nZXQtc2VydmVyMS0yLm50ZC5uaW50ZW5kby5jb20wgZ8wDQYJKoZIhvcNAQEBBQAD\ngY0AMIGJAoGBAMx2BX9LqyTXZC9kUipSQb7Uz9LEUAXZtmDNBQBXAm88f2fFciqh\nWFYSSxBHI7FNHuGeAO4RHvBFuH6a7pkmA+a0fPLxcZLc38F8E8XCqZDr4F9zRtWf\nsv8bC5zriNEOQh6uKcHjEmz7Uwez1KijsX7iZ8pipt2Xe/+LLopjnk9FAgMBAAGj\nezB5MAkGA1UdEwQCMAAwLAYJYIZIAYb4QgENBB8WHU9wZW5TU0wgR2VuZXJhdGVk\nIENlcnRpZmljYXRlMB0GA1UdDgQWBBTIo+sNJbM7l5UAL1q6JBY8L3KaBDAfBgNV\nHSMEGDAWgBTlIuYUb8WbKBJ+o53dBSSLJalVSzANBgkqhkiG9w0BAQsFAAOCAQEA\nn2gi/H/dSO8tx2yr9OjmSjX1qRPOKtzg6uEFn0e8SqvTZI1wou90QvyAhwCzh3sW\nZ7/r7ka0ZHABTUGJ9Bq0B5MYgC0tQ+YSUMrZMlNAINHvx+Tst/sSdxwq2ELWRuwO\njc/M/hBlpTRJ2HFfigBhw0fzt4fLZ9oiLNgXzCiF7BZBd5vymK3pzPky5Jg10spo\nZZeNyyxtP7glND2aKFR3jDRrEiFdJQhYcAT9VAebrkQQX0tKpFwC6Moo5N+btN7C\n0WquLo+jLAa4Kfwvgj6ZAe3l5SwLNkJztTs5LZNsWMpM03zBoPqrUIVEoGoZTC5W\n9gjnjILI6+vB0Xv9R6Azjg==\n-----END CERTIFICATE-----";
const char g_pTestCaCert3[] = "-----BEGIN CERTIFICATE-----\nMIIDMzCCAhugAwIBAgIJAPUgPwiq1RviMA0GCSqGSIb3DQEBCwUAMF4xCzAJBgNV\nBAYTAlVTMRMwEQYDVQQIDApXYXNoaW5ndG9uMQwwCgYDVQQKDANOVEQxLDAqBgNV\nBAMMI2NhLm50ZC1uZXQtc2VydmVyMS5udGQubmludGVuZG8uY29tMB4XDTE2MDYx\nNDE3MDUzOFoXDTE3MDYxNDE3MDUzOFowWzELMAkGA1UEBhMCVVMxEzARBgNVBAgM\nCldhc2hpbmd0b24xDDAKBgNVBAoMA05URDEpMCcGA1UEAwwgbnRkLW5ldC1zZXJ2\nZXIxLm50ZC5uaW50ZW5kby5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGB\nALU8cJfeMjuT1wgdiUX7sd0N5q8iydgSTADflxnO06tCMbowaiOMRlMzLXEJ2ILT\nW9EaBtaiSovetvudv/2QuEDtVIa8EWK36jH2xdrHCrc/O6JiPvuqjkMyC6cp58DQ\ngP/U9Yis/6vAZj0jMO+omghMs3jys2MW5DkHwg901qv3AgMBAAGjezB5MAkGA1Ud\nEwQCMAAwLAYJYIZIAYb4QgENBB8WHU9wZW5TU0wgR2VuZXJhdGVkIENlcnRpZmlj\nYXRlMB0GA1UdDgQWBBS63PAv4/nFnsanChEyGZ7IlD7ZnDAfBgNVHSMEGDAWgBT5\n1u31CR3hItLzWqdN0S+SkDgUpzANBgkqhkiG9w0BAQsFAAOCAQEApBaSQChB5pJt\ndat1GA0z6hhSTgkW8RPMOnDa6u9CyZ2x6qpG6kH2+AEyA8po4m49VbOBqypurS6j\nr6g4VvlcZvGJ0n57WMDt9pgfuNDDLcTdGEyXJ8enPmFcNIdIu7l02L2+wOoHTs0Z\nNL8fIpUuH05hl0qfozEx69JheaQqQvfJnqNt2emMF43oKNoErpkwELhR7MzweIHe\nrZj8Wv2v/pbET+NQsPfGY3ykuwKUUC+74BUkUurs/AAmmPkTmX3klgOByGOvb9OQ\nGY3zKDXJZtCgci0tlcQTsLsELvG2oqt5PzNIP0lPBIxFaenpAG3eiKla6YMoSqHL\n87Grvojh5w==\n-----END CERTIFICATE-----";
const char g_pTestCaCertExpired[] = "-----BEGIN CERTIFICATE-----\nMIICuzCCAiQCCQCsxZGx6gDMgzANBgkqhkiG9w0BAQsFADCBoTELMAkGA1UEBhMC\nVVMxEzARBgNVBAgMCldhc2hpbmd0b24xEDAOBgNVBAcMB1JlZG1vbmQxETAPBgNV\nBAoMCE5pbnRlbmRvMS0wKwYDVQQLDCROaW50ZW5kbyBUZWNobm9sb2d5IERldmVs\nb3BtZW50IEluYy4xKTAnBgNVBAMMIG50ZC1uZXQtc2VydmVyMS5udGQubmludGVu\nZG8uY29tMB4XDTAwMDEwMjAwMTk1MFoXDTAwMDEwMzAwMTk1MFowgaExCzAJBgNV\nBAYTAlVTMRMwEQYDVQQIDApXYXNoaW5ndG9uMRAwDgYDVQQHDAdSZWRtb25kMREw\nDwYDVQQKDAhOaW50ZW5kbzEtMCsGA1UECwwkTmludGVuZG8gVGVjaG5vbG9neSBE\nZXZlbG9wbWVudCBJbmMuMSkwJwYDVQQDDCBudGQtbmV0LXNlcnZlcjEubnRkLm5p\nbnRlbmRvLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0nFXTfGqGDiN\nGg2RzEuLA2dHzyyZ8B/rCYeX1Hi1Ke2ipEJjpUeH7LupflI15X4eof/NHuCl6ZOz\n/daJlHTBff0H7hBjN/R/GwKgf8IG8cvS7GpENgcUIeP76EiokEaiP9cgW45O+q7H\nWURvMadQHKl2M/FzYOokdqrruZOXzqECAwEAATANBgkqhkiG9w0BAQsFAAOBgQBD\nTFQ4ETYFJzFEJX0UBGpwjUZrf8orHttbswDv4vaJNTyePVoUwjWUQvkWs2QInYL4\nh6fFPvlw4PLXDjnUBp9ZIPK7d3KTNLSJCo5GLYiAJf9FKqHW86jE6Kmm8k8MZu0O\nzjLv74Qd7P90EoiX5NeTlfRai4MnICXDozClBVO62w==\n-----END CERTIFICATE-----";
const char g_pTestCaCertInvalidFmt[] = "-----BEGIN\nMIIEOTCCAyGgAwIBAgIBATANBgkqhkiG9w0BAQUFADB6MRMwEQYKCZImiZPyLGQB\nGRYDb3JnMRYwFAYKCZImiZPyLGQBGRYGc2ltcGxlMRMwEQYDVQQKDApTaW1wbGUg\nSW5jMRowGAYDVQQLDBFTaW1wbGUgU2lnbmluZyBDQTEaMBgGA1UEAwwRU2ltcGxl\nIFNpZ25pbmcgQ0EwHhcNMTYwMTI1MjMyOTM2WhcNMTgwMTI0MjMyOTM2WjCBmDET\nMBEGCgmSJomT8ixkARkWA29yZzEWMBQGCgmSJomT8ixkARkWBnNpbXBsZTETMBEG\nA1UECgwKU2ltcGxlIEluYzEpMCcGA1UECwwgbnRkLW5ldC1zZXJ2ZXIxLm50ZC5u\naW50ZW5kby5jb20xKTAnBgNVBAMMIG50ZC1uZXQtc2VydmVyMS5udGQubmludGVu\nZG8uY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3qVVe6OeFuP8\n8ezCh/bZ02yCeS6wjM7yYaxlDETaE88//CsikUSlQFH+9mg1p8JcteG3KKeGJtla\nYehyZRHsbOraNXLUzdJb/6j9aMOxFPnlmBe9/flJFSM0NGly3UH70CtJPiBp5HyB\nH+/A/pyISdPBYkebdg0t8F2WNfO5A0/qOP3QxI5ro6k/dW0z9hMX1B2A+d5jtOkC\nmEHsnkgXp9SMDyCabM9qSECBZ6mqQVIZLg1HQA0xdIgaJ0tQvtqzcIxrQs/ZS09K\nCm5bBPPerQ9q+e6u8+UbO3UnwIuujhfO+1GzRMtC4J16mf6LdqycmNbUxn8sS8R8\nTK6QmhJHoQIDAQABo4GqMIGnMA4GA1UdDwEB/wQEAwIFoDAJBgNVHRMEAjAAMB0G\nA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4EFgQUC0cFnuCaJXg/\nWU7Iotihbbv7Z3AwHwYDVR0jBBgwFoAUMAkDFn5aLSnSlX0Oa+nX46c6aQ0wKwYD\nVR0RBCQwIoIgbnRkLW5ldC1zZXJ2ZXIxLm50ZC5uaW50ZW5kby5jb20wDQYJKoZI\nhvcNAQEFBQADggEBAHgwuk87+eY2sz4DwlgghsLBkDFf0WZ+Hs05QaDCOP54C1QM\nnqU1djB448rhEo5OamhykZ/13VrhZwP7lsFYqrIG4QJCrJo4Z3d5gnG02bh08z/h\nWFHTqFNGCU5HFmG4amKoTB8VU6dlLE2aMNQnRVOrm02q4Q28mxKhynuHyE7E5vOy\nqziTQCULdO2/+ZLyKDsnUEdT/QZm5kTMjdynSrBgZ2/RPABMJOTL8yvNd3fdh33h\nyKXchj8O9AIse4DinQgEhfyh9N1K9FdK1JimvefYk3KtDxn+8Z/v6KdZ9ZD676gW\nCfpEoHxDcTOESAyxulRKp3nBRulL7zFO9OMSFnE=\n-----END C";

const char g_pTestRvkRootCa[] =
"-----BEGIN CERTIFICATE-----\n"
"MIIGEDCCA/igAwIBAgIJAOZLl0yKKgYKMA0GCSqGSIb3DQEBCwUAMIGUMQswCQYD\n"
"VQQGEwJVUzEOMAwGA1UECAwFVGV4YXMxEDAOBgNVBAcMB0dhcmxhbmQxEjAQBgNV\n"
"BAoMCUhJUUVTIExMQzEUMBIGA1UECwwLRW5naW5lZXJpbmcxFjAUBgNVBAMMDUhJ\n"
"UUVTIFJvb3QgQ0ExITAfBgkqhkiG9w0BCQEWEndlYmFkbWluQGhpcWVzLmNvbTAe\n"
"Fw0xNzAzMTUxNTU4MjJaFw00NDA3MzExNTU4MjJaMIGUMQswCQYDVQQGEwJVUzEO\n"
"MAwGA1UECAwFVGV4YXMxEDAOBgNVBAcMB0dhcmxhbmQxEjAQBgNVBAoMCUhJUUVT\n"
"IExMQzEUMBIGA1UECwwLRW5naW5lZXJpbmcxFjAUBgNVBAMMDUhJUUVTIFJvb3Qg\n"
"Q0ExITAfBgkqhkiG9w0BCQEWEndlYmFkbWluQGhpcWVzLmNvbTCCAiIwDQYJKoZI\n"
"hvcNAQEBBQADggIPADCCAgoCggIBAKe2rXtqYWFpzhpeezr2nKUWIiD13lgYDO7l\n"
"4H0b9DlEgp+N4Qp4+grTWcW1Kf5Ha52VJpEmorPbeEWeKfzLfxLJW9+ljp3MfxkA\n"
"MjsoICYAsHVtNdSlX7cp3/TWoeRT61PyxXQH/g/wQrskphm+3kJmLxTBwrVr854U\n"
"iMYumljl5FxgxPBYMvMUe7M3nXfE4Wq3Hv6ZGKjtT964/h6I38KQgG9GhtMWVHUC\n"
"yDn0bY1lDCrPiN94S2BAfQSs2z/qd+K2nLyFxcdBDVWAiCOPb25NimHdB5C+jr/J\n"
"0zu8UGNcWMy1OBAgTo3qXrJx4nfYj7OAKYUJZYqd+Pun1s+T4CLlN5AUDJNqBq+j\n"
"PyVGBkxikgboXMuHhYkY30/4pbJGPmW+Bnfw4bAXKxeL7Z3vsluDDEIkuEf4LN9R\n"
"U6vWw3ny7C6nCuT6dxMXHgxWXJDRgBtnaZfzilRsEE6r6dVtToUhDG2c8pDd77p5\n"
"IezZCqN9I8JcvU6/LYNTwgyWRf2NfZ3rwPu3f2APW9iT38qvusfIat8HySWBldbd\n"
"HlU26QrmUYv5FX0gokHgXMe6+ucSV61xJg+GMwGiLFaWDpRI6Ut1py0YhMjaYIg2\n"
"i8lkIcmhAYWrdOugdI/KdNrogx6oVV4yZfCNWpcA+JXjPTnnK/5Rxa7fDQ+bYN+w\n"
"QG3+b62DAgMBAAGjYzBhMB0GA1UdDgQWBBRT6TkhTYCQUPNTb1FhtLzsMA2adzAf\n"
"BgNVHSMEGDAWgBRT6TkhTYCQUPNTb1FhtLzsMA2adzAPBgNVHRMBAf8EBTADAQH/\n"
"MA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOCAgEAU7rXy7cAQxH47UQk\n"
"Vcr5YsKmJXzChodifrfma/NozKypyDZOqIV8Fq7kwF66lTw0JTpcC22bAcETW+Fy\n"
"RbMGAERfburx0yNk6+H39J9Bs130w3VVftzR47NwwcbtffgEoe15Kcpix6QR3rIS\n"
"jMzo9Pv0qTzHpdLh5lbdpiRIxHBz8neVqvg8BDAXOEJpw1Ua5wNM6y+MKS5vWh4a\n"
"XV9A39+wjGE1tCG/ZoUotLXT7jDv2l+J21SkYWLKemKOQERiuW48t9kwPtdx6k4d\n"
"zlCQgpbvkwkRItjCyQGzd8i/e8sa9JsOcZQLVZyEj/19ZdaNgdyUzvmyt6MvcdOj\n"
"4XTXwLsueg6nmnS9S5lA5nbnX0fjOzsFXf4UqW5WdrRWDZUuwURhHQnX5IQW+vQ6\n"
"jj7UCatlu3o2DU89vY10FfaexlhXSikQIrBgzMHKTRlNUweVIAYiyLxwaGIwTcx8\n"
"mmLI1FrE1xeaoteBfKiCetxNo9LySYN9OtM4MC/UEd05mSggPveXS4+V9GGOiaOv\n"
"toNiMwcuMHJ7YTHbdslVKDHFwpEpcqQnWD9otSoS9YZ7sDakQqVtyNNZWUKX9q+D\n"
"W0y5PNfufQnBJUU6HsPClzB25NTG3WD0TkL0zHDUsmQhsEelfPAIv/+Tje8zKNPP\n"
"7sSuZ6VlV+nLIxSm1X7bYgvDdPM=\n"
"-----END CERTIFICATE-----\n";

const char g_pTestRvkIntermediateCa[] =
"-----BEGIN CERTIFICATE-----\n"
"MIIGBDCCA+ygAwIBAgICEAAwDQYJKoZIhvcNAQELBQAwgZQxCzAJBgNVBAYTAlVT\n"
"MQ4wDAYDVQQIDAVUZXhhczEQMA4GA1UEBwwHR2FybGFuZDESMBAGA1UECgwJSElR\n"
"RVMgTExDMRQwEgYDVQQLDAtFbmdpbmVlcmluZzEWMBQGA1UEAwwNSElRRVMgUm9v\n"
"dCBDQTEhMB8GCSqGSIb3DQEJARYSd2ViYWRtaW5AaGlxZXMuY29tMB4XDTE3MDMx\n"
"NTE2MDQxMVoXDTI3MDMxMzE2MDQxMVowgYwxCzAJBgNVBAYTAlVTMQ4wDAYDVQQI\n"
"DAVUZXhhczESMBAGA1UECgwJSElRRVMgTExDMRQwEgYDVQQLDAtFbmdpbmVlcmlu\n"
"ZzEgMB4GA1UEAwwXSElRRVMgSW50ZXJtZWRpYXRlIENBIDAxITAfBgkqhkiG9w0B\n"
"CQEWEndlYmFkbWluQGhpcWVzLmNvbTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC\n"
"AgoCggIBAKtGa/r3j/HC9Q/CAKRuDqBHJyga7cXhg7XsKHMMnsOIeWRozDcJXSRQ\n"
"p7a4JOnkcBM6aDKf9Rpg3PUHKduHw4JeI3ON04BBS2/C2Fc9sTYVdIK8FfaB80q8\n"
"K2ELnkuwfbzBUr6uh/dxAdCYoxZa1bW4vfj7L+vy1iQOaFIHF8u/mN6b4F/uiTwg\n"
"hPslTo5FU9q8cKxyJKX/AMlVc8zP8ia4sePg+ot6a3mi65N53/VyXUD/pFYsOAbg\n"
"DLr21xEsg6ccaKs4tGA+5hbu4Q3qlUtjge/SJuDUNWqW10YBuEWYPPKekYZHQ2yz\n"
"Pl/ktD2zPL5rGaSWBIVNVFNJqr5Q//SgUTTX6KaykAHN+jTKJxJQWASq2XwDPFRj\n"
"b2FSTfXxLW8/1DYtZv0Qv/ekT+oXFlkcL7OeB7VdpJPGG9ygxTs7NkQqPNSzmuM8\n"
"r9AtF1ukigOu00N+WZfrp81vxHvN0jcjzkkt79d9jhsLe82rksa/Gs1s0eZSkibT\n"
"UKRaFP2g8ltGVN8C+NJESdgCYOPTVZFa2TYhERtjZu46WrVTIK5NxrWo/3SqoXi4\n"
"RYnQBWB6BHVI9AFJpcGSgtNTuJ9vKME7SDde64wNWy+WfBKEzjTptuNtieXlffze\n"
"yaANgbJx16v9KRX+KUhQtrKoGjBN4kOkXd0oJqXJiGkDOex0znOfAgMBAAGjZjBk\n"
"MB0GA1UdDgQWBBR4BPtq2F3fBjax9lC5xnJ3IDiqtzAfBgNVHSMEGDAWgBRT6Tkh\n"
"TYCQUPNTb1FhtLzsMA2adzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB/wQE\n"
"AwIBhjANBgkqhkiG9w0BAQsFAAOCAgEAOKc57eIgvJUdmu6RMZ7i/ojwqpkVW7q6\n"
"5M2enC8r8W+6/XVqn5hm0vZmRnNzVIVcFFO+N3m6uKgjafHN/5zEYM/hEq1tIiO/\n"
"bb5b0ZHhUt74dHt3duL88M1/48lm6TCZU2KUgaffYnDMJxrmwTXSCPJR5uWGiWiK\n"
"GL7WlK9WaoM0qnNohybpmLGBiSBrRA+sq//GjHr1bk4QLJRHDG4T8i6QTZWrATbT\n"
"5jXd/iFst693cV19569zdn4nujEQNO5Q8owZ5QS0XZEmnquHg7Ifd8nIPMROF0ZT\n"
"unlPb9GMWvTNuozGusXotFvzgdMdVK9CPMc6FE4BzltO9lF5o+NcY8tvcj6G8Z1g\n"
"pezuDUNw4HTXfmDPxUrWDJjLameL9qSaXQFV37Ilo5e7y/mHXc/L2vK+QPHtN2dx\n"
"ZcCX6Fody2GOJpnQlxU4CxgGmo2aMw2hWvBfFq1SwXtUV1LpCvjTQ21eeSGQnP3g\n"
"uJvYyPQIpZLX43It80qQ0jwTzVOSXlte1AsWT9HQvx20SuKbDvv0C+no0shBDvxf\n"
"0qP9emWRYS5xIGdYHGmUV9BEhfCu9lZH3KNDBXJDqfdjZANpv1DCG3V63LwrdQeG\n"
"3vuIUo+xzxqtYQ3EGW6ZFJldcZsCHLCcTRBTJntoSyjfC5Cj4i9AXFpBjVsYpr6r\n"
"z67KuQjyKHE=\n"
"-----END CERTIFICATE-----\n";


const uint8_t g_pTestCrlRvkServer[] =
{
    0x30, 0x82, 0x03, 0x35, 0x30, 0x82, 0x01, 0x1d, 0x02, 0x01, 0x01, 0x30,
    0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b,
    0x05, 0x00, 0x30, 0x81, 0x8c, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55,
    0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x0e, 0x30, 0x0c, 0x06, 0x03,
    0x55, 0x04, 0x08, 0x0c, 0x05, 0x54, 0x65, 0x78, 0x61, 0x73, 0x31, 0x12,
    0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x0c, 0x09, 0x48, 0x49, 0x51,
    0x45, 0x53, 0x20, 0x4c, 0x4c, 0x43, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03,
    0x55, 0x04, 0x0b, 0x0c, 0x0b, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x65,
    0x72, 0x69, 0x6e, 0x67, 0x31, 0x20, 0x30, 0x1e, 0x06, 0x03, 0x55, 0x04,
    0x03, 0x0c, 0x17, 0x48, 0x49, 0x51, 0x45, 0x53, 0x20, 0x49, 0x6e, 0x74,
    0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x20, 0x43, 0x41,
    0x20, 0x30, 0x31, 0x21, 0x30, 0x1f, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
    0xf7, 0x0d, 0x01, 0x09, 0x01, 0x16, 0x12, 0x77, 0x65, 0x62, 0x61, 0x64,
    0x6d, 0x69, 0x6e, 0x40, 0x68, 0x69, 0x71, 0x65, 0x73, 0x2e, 0x63, 0x6f,
    0x6d, 0x17, 0x0d, 0x31, 0x37, 0x30, 0x33, 0x31, 0x37, 0x31, 0x32, 0x35,
    0x37, 0x35, 0x32, 0x5a, 0x17, 0x0d, 0x31, 0x37, 0x30, 0x37, 0x31, 0x35,
    0x31, 0x32, 0x35, 0x37, 0x35, 0x32, 0x5a, 0x30, 0x2a, 0x30, 0x13, 0x02,
    0x02, 0x10, 0x00, 0x17, 0x0d, 0x31, 0x37, 0x30, 0x33, 0x31, 0x35, 0x31,
    0x36, 0x32, 0x34, 0x32, 0x31, 0x5a, 0x30, 0x13, 0x02, 0x02, 0x10, 0x01,
    0x17, 0x0d, 0x31, 0x37, 0x30, 0x33, 0x31, 0x35, 0x31, 0x37, 0x31, 0x30,
    0x34, 0x30, 0x5a, 0xa0, 0x30, 0x30, 0x2e, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x78, 0x04, 0xfb, 0x6a,
    0xd8, 0x5d, 0xdf, 0x06, 0x36, 0xb1, 0xf6, 0x50, 0xb9, 0xc6, 0x72, 0x77,
    0x20, 0x38, 0xaa, 0xb7, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x1d, 0x14, 0x04,
    0x04, 0x02, 0x02, 0x10, 0x02, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48,
    0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x03, 0x82, 0x02, 0x01,
    0x00, 0x3a, 0x07, 0xf3, 0x97, 0xad, 0x4d, 0xf6, 0x82, 0x76, 0xc8, 0xb9,
    0xf7, 0x0d, 0xf3, 0x0a, 0x1a, 0xd3, 0x28, 0x0e, 0x3d, 0x08, 0x03, 0x36,
    0x5f, 0x0c, 0xfb, 0x2e, 0x44, 0x57, 0x52, 0x67, 0x60, 0xfa, 0x3f, 0xdd,
    0xb8, 0x51, 0xf3, 0x87, 0xf1, 0xb9, 0xb5, 0xfd, 0xa5, 0xbe, 0xac, 0x28,
    0x35, 0xa7, 0x08, 0xb5, 0x0b, 0x49, 0x24, 0xd3, 0x86, 0xd9, 0x9c, 0xab,
    0xb3, 0xee, 0xe6, 0x0e, 0xdf, 0xd2, 0xbe, 0x16, 0x2e, 0xdd, 0xf8, 0x05,
    0x14, 0xb5, 0x0a, 0x83, 0x32, 0x79, 0xef, 0x5d, 0xed, 0x95, 0x2f, 0x97,
    0xc5, 0xa6, 0xa3, 0x1a, 0x3d, 0x49, 0xe8, 0xb7, 0x2b, 0x61, 0xd8, 0x59,
    0xfc, 0x17, 0x21, 0x54, 0x5c, 0xd1, 0x2d, 0xe3, 0x64, 0x1f, 0x4b, 0xd0,
    0x15, 0xf3, 0x51, 0x43, 0x3d, 0x14, 0x6a, 0x49, 0x65, 0x18, 0xa8, 0xde,
    0x82, 0xf9, 0xd5, 0x05, 0x47, 0xf8, 0x3f, 0x78, 0xe8, 0x62, 0xd3, 0xd0,
    0x15, 0x7e, 0xb8, 0x01, 0x9a, 0x05, 0xd1, 0xe0, 0x62, 0x03, 0x38, 0x57,
    0xe3, 0xe5, 0xf2, 0x7a, 0xbd, 0xe1, 0xf8, 0xda, 0x06, 0xae, 0x12, 0xf5,
    0xa0, 0x06, 0x37, 0x94, 0x56, 0x8a, 0x6b, 0xa2, 0xf1, 0x51, 0x29, 0x8d,
    0x3c, 0x4d, 0x2e, 0x8e, 0xd5, 0x54, 0x38, 0x10, 0xcf, 0xd5, 0x41, 0xbd,
    0xd3, 0x51, 0xc5, 0x31, 0x8e, 0x85, 0x7d, 0x90, 0x7d, 0xab, 0x79, 0x3a,
    0xed, 0x18, 0x60, 0x51, 0x19, 0x10, 0xd1, 0xb4, 0x73, 0xf8, 0x25, 0x66,
    0x18, 0x01, 0xee, 0xae, 0x78, 0xa4, 0x2b, 0x02, 0x34, 0x37, 0xf2, 0xeb,
    0x2a, 0xdf, 0x40, 0x05, 0x72, 0x3f, 0xc4, 0x55, 0x93, 0xae, 0x3e, 0x8f,
    0xf5, 0xbf, 0xe0, 0xb5, 0x7e, 0xf3, 0x43, 0x18, 0xfa, 0x28, 0x06, 0x2b,
    0x5d, 0xf2, 0x49, 0xd9, 0xde, 0x22, 0x45, 0x5b, 0x88, 0xfb, 0x05, 0x12,
    0x58, 0x35, 0x40, 0x05, 0x93, 0x62, 0xb0, 0xf2, 0x4c, 0x10, 0xfd, 0x0b,
    0xf4, 0x0b, 0x5f, 0xa8, 0xd3, 0x47, 0x31, 0x5d, 0xa9, 0x38, 0x1b, 0xe3,
    0x0b, 0x26, 0x0c, 0x0e, 0xc7, 0x5a, 0xcf, 0xeb, 0x69, 0x07, 0x3e, 0x4b,
    0xf1, 0x5b, 0xb7, 0x07, 0xb6, 0x0a, 0x04, 0xa0, 0x3a, 0x67, 0x41, 0x7a,
    0xc7, 0x13, 0xe8, 0xbe, 0x75, 0x7f, 0x37, 0xa7, 0x8c, 0x84, 0x3d, 0x51,
    0x2a, 0xfb, 0x59, 0xd6, 0xa7, 0x7b, 0xf5, 0x9c, 0xdf, 0x4b, 0x50, 0x64,
    0x51, 0x3a, 0x0a, 0xc4, 0x87, 0x6e, 0x1a, 0xe7, 0x1f, 0x7d, 0x3a, 0x05,
    0x8d, 0xb3, 0xb5, 0x41, 0x4c, 0x25, 0xd0, 0x3c, 0x3a, 0xc1, 0x70, 0x0e,
    0xee, 0x82, 0xc5, 0xb5, 0x65, 0xa3, 0x59, 0xca, 0xc0, 0x83, 0xa1, 0x15,
    0x7e, 0x85, 0x2d, 0x56, 0x28, 0x31, 0x65, 0x45, 0xa8, 0x7c, 0x80, 0xe5,
    0x5d, 0xf0, 0xb6, 0x2d, 0xff, 0x5d, 0xc2, 0x89, 0x17, 0xda, 0x5a, 0x58,
    0x97, 0xd7, 0x5b, 0x77, 0xef, 0x72, 0x45, 0x00, 0xe0, 0xd1, 0x00, 0xf4,
    0x7c, 0x05, 0x8d, 0x42, 0x52, 0xea, 0xd7, 0xc0, 0x01, 0xdd, 0xbd, 0x6a,
    0x1f, 0xe3, 0x39, 0x70, 0xe3, 0x4c, 0xd2, 0x96, 0xc7, 0xe3, 0x41, 0x69,
    0x40, 0xac, 0xdb, 0x48, 0xe9, 0xa3, 0xe0, 0xf6, 0x29, 0x68, 0xd8, 0x50,
    0xc0, 0xbd, 0x15, 0x19, 0x03, 0x1a, 0x16, 0x74, 0x7f, 0xc2, 0xca, 0xcf,
    0x19, 0x06, 0x4a, 0x0b, 0x1e, 0x74, 0x2a, 0xc0, 0x73, 0x09, 0xd7, 0x5e,
    0xd7, 0x45, 0xe7, 0x7c, 0x3d, 0x94, 0xd4, 0x6f, 0xa9, 0xce, 0x3b, 0x55,
    0xcf, 0xc2, 0xac, 0x74, 0x72, 0xba, 0x3f, 0xfe, 0x22, 0x56, 0x0b, 0x7e,
    0xf3, 0x39, 0x7d, 0xf0, 0x98, 0xf5, 0xc8, 0xc4, 0x75, 0x04, 0x9b, 0x94,
    0xc2, 0xc5, 0x1e, 0xbc, 0xd5, 0xed, 0x40, 0xff, 0xc2, 0xc3, 0x29, 0x48,
    0xb5, 0xca, 0x01, 0xcc, 0xca, 0x49, 0xdc, 0x5e, 0xd8
};


const uint8_t g_pTestCrlRvkIntermediateCa[] =
{
    0x30, 0x82, 0x03, 0x3d, 0x30, 0x82, 0x01, 0x25, 0x02, 0x01, 0x01, 0x30,
    0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b,
    0x05, 0x00, 0x30, 0x81, 0x94, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55,
    0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x0e, 0x30, 0x0c, 0x06, 0x03,
    0x55, 0x04, 0x08, 0x0c, 0x05, 0x54, 0x65, 0x78, 0x61, 0x73, 0x31, 0x10,
    0x30, 0x0e, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x07, 0x47, 0x61, 0x72,
    0x6c, 0x61, 0x6e, 0x64, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04,
    0x0a, 0x0c, 0x09, 0x48, 0x49, 0x51, 0x45, 0x53, 0x20, 0x4c, 0x4c, 0x43,
    0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x0b, 0x45,
    0x6e, 0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x31, 0x16,
    0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x0d, 0x48, 0x49, 0x51,
    0x45, 0x53, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x41, 0x31, 0x21,
    0x30, 0x1f, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x09,
    0x01, 0x16, 0x12, 0x77, 0x65, 0x62, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x40,
    0x68, 0x69, 0x71, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x17, 0x0d, 0x31,
    0x37, 0x30, 0x33, 0x31, 0x37, 0x31, 0x33, 0x33, 0x39, 0x34, 0x32, 0x5a,
    0x17, 0x0d, 0x31, 0x37, 0x30, 0x34, 0x31, 0x36, 0x31, 0x33, 0x33, 0x39,
    0x34, 0x32, 0x5a, 0x30, 0x2a, 0x30, 0x13, 0x02, 0x02, 0x10, 0x00, 0x17,
    0x0d, 0x31, 0x37, 0x30, 0x33, 0x31, 0x37, 0x31, 0x33, 0x33, 0x39, 0x31,
    0x35, 0x5a, 0x30, 0x13, 0x02, 0x02, 0x10, 0x01, 0x17, 0x0d, 0x31, 0x37,
    0x30, 0x33, 0x31, 0x35, 0x31, 0x36, 0x32, 0x36, 0x35, 0x32, 0x5a, 0xa0,
    0x30, 0x30, 0x2e, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18,
    0x30, 0x16, 0x80, 0x14, 0x53, 0xe9, 0x39, 0x21, 0x4d, 0x80, 0x90, 0x50,
    0xf3, 0x53, 0x6f, 0x51, 0x61, 0xb4, 0xbc, 0xec, 0x30, 0x0d, 0x9a, 0x77,
    0x30, 0x0b, 0x06, 0x03, 0x55, 0x1d, 0x14, 0x04, 0x04, 0x02, 0x02, 0x10,
    0x02, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01,
    0x01, 0x0b, 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00, 0x03, 0x22, 0x61,
    0xaf, 0x3a, 0xf5, 0x3d, 0x36, 0xfa, 0x32, 0x14, 0x7a, 0xf9, 0xdc, 0xcf,
    0x93, 0xfc, 0x96, 0x71, 0xf7, 0x7c, 0x7f, 0x7d, 0x31, 0x02, 0xbd, 0x34,
    0x65, 0x86, 0xf1, 0x0a, 0x11, 0x35, 0x7c, 0x24, 0x03, 0x4a, 0x47, 0xa5,
    0xeb, 0xb8, 0x42, 0x10, 0x0b, 0xa0, 0xcd, 0xd7, 0xca, 0x63, 0x5f, 0xce,
    0xa0, 0xbd, 0xc5, 0xa7, 0x1f, 0x76, 0x0f, 0xb4, 0x33, 0x3b, 0xb4, 0x2e,
    0x7c, 0x23, 0x54, 0x89, 0xd6, 0x3e, 0x1b, 0x0e, 0x2e, 0xa0, 0x02, 0xf3,
    0x99, 0x99, 0xea, 0xf2, 0xfa, 0xd9, 0x55, 0x95, 0xf8, 0x5c, 0x6a, 0x4f,
    0x5b, 0x11, 0x91, 0x4a, 0x40, 0x04, 0x4b, 0x61, 0x7d, 0x1a, 0x76, 0x98,
    0x36, 0x8e, 0x87, 0xdb, 0x43, 0x1b, 0x63, 0xbe, 0x03, 0xd3, 0xbf, 0x51,
    0x5a, 0xae, 0x1f, 0x51, 0xd2, 0xb6, 0xca, 0xb7, 0x6f, 0xe1, 0xea, 0x93,
    0x1b, 0x25, 0x17, 0x7f, 0x12, 0x59, 0x4e, 0xf4, 0x72, 0x84, 0x32, 0x6a,
    0x1a, 0x1c, 0x83, 0x7e, 0x91, 0x11, 0xcd, 0xb5, 0x42, 0x3f, 0x8b, 0x10,
    0x26, 0x2e, 0x0d, 0x25, 0xf1, 0xef, 0x13, 0xbc, 0xef, 0x5d, 0xdb, 0x5c,
    0xd5, 0x40, 0x21, 0x58, 0x71, 0x99, 0xa3, 0x40, 0x4f, 0x6e, 0x87, 0x41,
    0xc4, 0x1d, 0x3b, 0xd5, 0x17, 0xe9, 0xa4, 0x0b, 0x7c, 0xa9, 0x6f, 0xc6,
    0x92, 0x3c, 0xb8, 0x6f, 0x80, 0x68, 0x5f, 0xd4, 0x43, 0x0d, 0x27, 0xb4,
    0xae, 0xad, 0x77, 0x4f, 0x31, 0x8b, 0x6a, 0x4d, 0xfe, 0xf9, 0xab, 0x43,
    0x60, 0x35, 0xc6, 0x18, 0x67, 0xfa, 0x48, 0xc1, 0x7b, 0x3f, 0x0b, 0x8f,
    0x00, 0xb1, 0xa9, 0x83, 0x15, 0x8a, 0x48, 0xbb, 0xf5, 0x6a, 0xd0, 0x7c,
    0xa1, 0x02, 0x50, 0xe0, 0x65, 0x60, 0x51, 0x74, 0x68, 0x82, 0x4f, 0x41,
    0x63, 0x58, 0x12, 0x62, 0xd1, 0xe6, 0x26, 0x05, 0x6e, 0xd4, 0x6f, 0x75,
    0x94, 0xf7, 0xab, 0x71, 0x7f, 0x97, 0x79, 0xa3, 0x82, 0x1a, 0xf3, 0xc9,
    0x29, 0x48, 0x7c, 0x1e, 0x56, 0xce, 0x71, 0x62, 0x82, 0xb9, 0x2c, 0xc2,
    0x99, 0x22, 0x92, 0xe6, 0x06, 0xc8, 0x90, 0xb7, 0x7b, 0xc8, 0xd2, 0xfc,
    0x55, 0x4f, 0x58, 0x21, 0x16, 0x54, 0x57, 0x50, 0xaa, 0xf9, 0xa1, 0x9e,
    0xbe, 0x9f, 0x7b, 0xfc, 0x85, 0x56, 0xb6, 0x13, 0xfa, 0xb0, 0x57, 0x74,
    0x26, 0x12, 0xcf, 0xd2, 0x3a, 0xce, 0xd0, 0x00, 0xe3, 0x3a, 0xb1, 0x65,
    0xe2, 0x19, 0x91, 0x3c, 0x87, 0x1c, 0x1a, 0xfb, 0xe4, 0x95, 0xc7, 0xee,
    0x6b, 0xb2, 0x9e, 0x4f, 0xc6, 0xb0, 0xaf, 0x27, 0x8c, 0xf5, 0x9e, 0x5e,
    0xcb, 0x5b, 0xb8, 0x6f, 0x94, 0xa0, 0x72, 0x4c, 0x7e, 0x2c, 0x1c, 0xdf,
    0x1b, 0xcf, 0x6a, 0xad, 0x6c, 0x5f, 0x94, 0x74, 0x15, 0xaf, 0x9b, 0x72,
    0x09, 0x32, 0x61, 0x51, 0xf7, 0x49, 0x78, 0xa1, 0x2c, 0xa8, 0x7a, 0x8d,
    0x48, 0x6c, 0xc1, 0x12, 0x1a, 0x39, 0x60, 0x07, 0x0e, 0x80, 0x98, 0x80,
    0xb0, 0xde, 0x44, 0x8e, 0x08, 0x66, 0x78, 0x66, 0xca, 0x9b, 0x60, 0x7b,
    0xfc, 0xd1, 0x04, 0xba, 0x40, 0x92, 0x59, 0x37, 0x5a, 0x5a, 0xb6, 0x55,
    0xdf, 0x49, 0x47, 0xc8, 0x64, 0x82, 0x59, 0xb9, 0x2c, 0x4f, 0x01, 0x93,
    0x97, 0x15, 0x82, 0x74, 0x4d, 0xfa, 0x39, 0xd7, 0xc8, 0xe6, 0x01, 0xfd,
    0x1d, 0x8c, 0x6c, 0x1c, 0x6d, 0xe6, 0x08, 0x6c, 0x50, 0xd7, 0xc6, 0xc0,
    0x46, 0x1a, 0xe0, 0x2e, 0x14, 0xa4, 0x58, 0x99, 0x92, 0xa8, 0x13, 0xef,
    0xc9, 0x38, 0xcf, 0x8f, 0xbb, 0x1e, 0x0b, 0x93, 0xfd, 0x07, 0x6a, 0x97,
    0x9b, 0x66, 0x0c, 0xb8, 0x56, 0x5d, 0xa2, 0xd5, 0x0e, 0x5c, 0x2f, 0xec,
    0xc1, 0x04, 0xa0, 0xd2, 0x0d, 0x2c, 0x15, 0xaa, 0x51, 0x72, 0xd8, 0x56,
    0x63, 0x10, 0x7f, 0x9f, 0x19
};


const uint8_t g_pTestCrlRvkIntermediateCaBadSig[] =
{
    0x30, 0x82, 0x03, 0x28, 0x30, 0x82, 0x01, 0x10, 0x02, 0x01, 0x01, 0x30,
    0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b,
    0x05, 0x00, 0x30, 0x81, 0x94, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55,
    0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x0e, 0x30, 0x0c, 0x06, 0x03,
    0x55, 0x04, 0x08, 0x0c, 0x05, 0x54, 0x65, 0x78, 0x61, 0x73, 0x31, 0x10,
    0x30, 0x0e, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0c, 0x07, 0x47, 0x61, 0x72,
    0x6c, 0x61, 0x6e, 0x64, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04,
    0x0a, 0x0c, 0x09, 0x48, 0x49, 0x51, 0x45, 0x53, 0x20, 0x4c, 0x4c, 0x43,
    0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x0c, 0x0b, 0x45,
    0x6e, 0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x31, 0x16,
    0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x0d, 0x48, 0x49, 0x51,
    0x45, 0x53, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x41, 0x31, 0x21,
    0x30, 0x1f, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x09,
    0x01, 0x16, 0x12, 0x77, 0x65, 0x62, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x40,
    0x68, 0x69, 0x71, 0x65, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x17, 0x0d, 0x31,
    0x37, 0x30, 0x33, 0x31, 0x35, 0x31, 0x36, 0x32, 0x39, 0x31, 0x34, 0x5a,
    0x17, 0x0d, 0x31, 0x37, 0x30, 0x34, 0x31, 0x34, 0x31, 0x36, 0x32, 0x39,
    0x31, 0x34, 0x5a, 0x30, 0x15, 0x30, 0x13, 0x02, 0x02, 0x10, 0x01, 0x17,
    0x0d, 0x31, 0x37, 0x30, 0x33, 0x31, 0x35, 0x31, 0x36, 0x32, 0x36, 0x35,
    0x32, 0x5a, 0xa0, 0x30, 0x30, 0x2e, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d,
    0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x53, 0xe9, 0x39, 0x21, 0x4d,
    0x80, 0x90, 0x50, 0xf3, 0x53, 0x6f, 0x51, 0x61, 0xb4, 0xbc, 0xec, 0x30,
    0x0d, 0x9a, 0x77, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x1d, 0x14, 0x04, 0x04,
    0x02, 0x02, 0x10, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
    0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00,
    0xa6, 0xe0, 0x46, 0x1b, 0x70, 0x54, 0x7a, 0x91, 0x1c, 0x93, 0x28, 0x6e,
    0xc2, 0x25, 0x4e, 0xb1, 0xe1, 0xe9, 0xcf, 0x00, 0xa7, 0x8c, 0x65, 0xee,
    0x56, 0x66, 0x0b, 0x06, 0x53, 0x87, 0x25, 0xda, 0xe1, 0xa2, 0xda, 0x7d,
    0x55, 0x16, 0x70, 0xa1, 0x50, 0x0a, 0x34, 0x3d, 0xdd, 0x39, 0x39, 0xfd,
    0xcb, 0xcd, 0x85, 0x07, 0x42, 0xab, 0xbc, 0xf4, 0x59, 0x60, 0x00, 0x49,
    0x13, 0xf7, 0xe9, 0xc9, 0xcb, 0x34, 0x73, 0x6f, 0x15, 0x0a, 0x33, 0xf1,
    0xe8, 0xf7, 0x0d, 0x8c, 0x85, 0xf4, 0x20, 0x32, 0x27, 0xf7, 0x52, 0x6c,
    0x6f, 0xad, 0xac, 0x8a, 0x08, 0x8e, 0x45, 0xab, 0x40, 0x10, 0xca, 0xf2,
    0xd7, 0xcb, 0x53, 0x4b, 0xf1, 0x86, 0xd9, 0x38, 0x49, 0x8f, 0xb2, 0x97,
    0x93, 0xfc, 0x17, 0x8d, 0x20, 0x94, 0xaa, 0x25, 0x79, 0x9a, 0x94, 0xef,
    0x8d, 0x4f, 0x9b, 0xfe, 0xcf, 0x07, 0x68, 0x3a, 0xca, 0x0e, 0xb5, 0x12,
    0x67, 0xd9, 0xf5, 0xcb, 0xe7, 0xf7, 0x02, 0x36, 0xde, 0xd7, 0x90, 0x6e,
    0x01, 0xd2, 0x31, 0xdf, 0x8a, 0x56, 0x18, 0xc2, 0x73, 0xc6, 0x4a, 0x6e,
    0x25, 0x0e, 0xe8, 0xe4, 0xa9, 0x89, 0x4a, 0x8e, 0x9d, 0x4a, 0x00, 0x9b,
    0xf9, 0x29, 0xb9, 0x9e, 0x7d, 0xda, 0x96, 0xc5, 0xd6, 0xda, 0x9d, 0x7c,
    0x9b, 0x4f, 0x95, 0xf0, 0x7c, 0x33, 0xad, 0x93, 0x45, 0x43, 0x45, 0xd9,
    0x59, 0x96, 0xef, 0x75, 0xee, 0x10, 0x57, 0x39, 0x07, 0x2b, 0xf2, 0x79,
    0x45, 0x17, 0x70, 0x9c, 0x13, 0xb4, 0xe3, 0x44, 0xb2, 0x9e, 0x87, 0x4f,
    0xcd, 0x1e, 0x16, 0x4d, 0xbd, 0xd8, 0xd1, 0x9e, 0xc3, 0xf9, 0x65, 0x96,
    0xd3, 0x23, 0x00, 0x1b, 0x00, 0xe8, 0x57, 0xda, 0x67, 0x53, 0x9d, 0xda,
    0x38, 0xa0, 0xe5, 0x38, 0x7d, 0x1f, 0x29, 0x3a, 0xa5, 0xc0, 0x8e, 0x19,
    0x0a, 0x5b, 0x78, 0x9e, 0xb3, 0x1b, 0x45, 0x0c, 0xde, 0x37, 0x39, 0xad,
    0x4b, 0x74, 0x8f, 0xd6, 0xe1, 0xbe, 0x9c, 0x8b, 0x9f, 0x49, 0xf2, 0x9d,
    0x28, 0x16, 0x68, 0x50, 0x2c, 0x0d, 0x0c, 0x5b, 0xb1, 0x43, 0xa9, 0x16,
    0x33, 0xee, 0xd5, 0xe0, 0x8b, 0xec, 0x6b, 0x8e, 0xdd, 0xb4, 0x67, 0xe7,
    0xee, 0x59, 0x13, 0x1f, 0xa1, 0x97, 0xfd, 0xe7, 0x12, 0x29, 0x1f, 0xdb,
    0x9c, 0xb0, 0xd1, 0xba, 0x0d, 0x2c, 0xdc, 0x16, 0x20, 0xc4, 0x47, 0x01,
    0xbe, 0x16, 0xcd, 0xce, 0x72, 0x19, 0xe9, 0x18, 0x1c, 0x91, 0x33, 0x9b,
    0xb7, 0x13, 0xe4, 0xc8, 0xcb, 0x74, 0x89, 0x48, 0x71, 0x8c, 0x98, 0x8b,
    0x5a, 0x8b, 0xf5, 0x28, 0x30, 0x3c, 0x67, 0xf3, 0xd6, 0xce, 0xaa, 0x39,
    0xda, 0x0c, 0x5c, 0x40, 0xd5, 0x65, 0x3f, 0x21, 0xf7, 0xb8, 0xf9, 0x2e,
    0xe1, 0x48, 0x11, 0xdb, 0xf0, 0x7c, 0x7a, 0x62, 0xa5, 0xe9, 0xba, 0x00,
    0x1f, 0xad, 0xbe, 0x62, 0x83, 0x14, 0x7e, 0x15, 0x5f, 0xa5, 0x20, 0x5e,
    0xa2, 0x25, 0x0f, 0xf0, 0xc9, 0x6a, 0xed, 0xdc, 0xad, 0x82, 0x56, 0xbf,
    0x0c, 0xd5, 0x2d, 0xe9, 0x13, 0xaa, 0x79, 0x2c, 0x20, 0x1c, 0x10, 0xeb,
    0x93, 0xe3, 0x23, 0xa7, 0x73, 0xf9, 0x6b, 0xc5, 0x22, 0x93, 0x00, 0x03,
    0x2c, 0x81, 0x2f, 0xb5, 0x83, 0xc5, 0x23, 0x8a, 0x13, 0x30, 0x88, 0xf0,
    0xde, 0x42, 0x38, 0xa7, 0x0f, 0x1c, 0xb2, 0xf1, 0x80, 0x22, 0x20, 0x28,
    0xe4, 0xd4, 0xa9, 0x92, 0xa6, 0xb6, 0xd3, 0x86, 0x35, 0x73, 0x48, 0x07,
    0xec, 0xd9, 0x5d, 0x96, 0xbb, 0xef, 0x42, 0x02, 0x88, 0x9e, 0xe0, 0xa6,
    0xac, 0x2f, 0x8e, 0x1d, 0x89, 0xa0, 0x91, 0x38, 0x3d, 0x14, 0x54, 0x58,
    0xdc, 0x76, 0xfa, 0xf9, 0x8f, 0xe4, 0xbb, 0x3a, 0xd3, 0xe9, 0x12, 0xac,
    0xf5, 0x22, 0x3c, 0xa2, 0xde, 0xad, 0xbe, 0xef
};
