﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

extern uintptr_t g_ConstructorObj;
extern uintptr_t g_DestructorObj;

template <class T>
class TestSingleton
{
public:
    static T& GetInstance()
    {
        static T singleton;
        return singleton;
    }

protected:
    TestSingleton() { g_ConstructorObj = reinterpret_cast<uintptr_t>(this); }
    ~TestSingleton() { g_DestructorObj = reinterpret_cast<uintptr_t>(this); }
};

class TestInheritSingleton : public TestSingleton<TestInheritSingleton>
{
};

template <class T>
class TestTemplate
{
public:
    explicit TestTemplate(T item)
        : m_Item(item)
    {
        g_ConstructorObj = reinterpret_cast<uintptr_t>(this);
    }
    ~TestTemplate()
    {
        g_DestructorObj = reinterpret_cast<uintptr_t>(this);
    }

    T GetItem() const { return m_Item; }

private:
    T m_Item;
};

