﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/svc/svc_Base.h>
#include <nn/nn_Log.h>
#include "test_StaticObject.h"

extern void SetClassId(int id);

char g_DummyArray[0x1000];

TestClass::TestClass(const char* name, int id)
    : m_Name(name)
{
    NN_LOG("TestClass Constructor: %s\n", m_Name);
    m_Id = id;
    SetClassId(GetId());
}

TestClass::~TestClass()
{
    NN_LOG("TestClass Destructor: %s\n", m_Name);
    SetClassId(GetId());
}

TestClass2::TestClass2(const char* name, int id)
    : TestClass(name, id)
{
    NN_LOG("TestClass2 Constructor: %s\n", m_Name);
    SetClassId(GetId() + IdOffset);
}

TestClass2::~TestClass2()
{
    NN_LOG("TestClass2 Destructor: %s\n", m_Name);
    SetClassId(GetId() + IdOffset);
}

// コンストラクタ・デストラクタが正常に呼ばれるかテスト
TestClass g_Test1("g_Test1", 0);
static TestClass g_Test2("g_Test2", 1);
const TestClass g_ConstClass("g_Test3", 2);
TestClass2 g_Test3("g_Test4", 3);

