﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <nn/os.h>
#include <nn/pwm/pwm.h>

#include <nnt/gtest/gtest.h>

TEST( Manual, Led )
{
    nn::pwm::Initialize();

    nn::pwm::ChannelSession session;
    nn::pwm::OpenSession(&session, nn::pwm::ChannelName::ChannelName_BlinkLed);

    nn::pwm::SetEnabled(&session, true);

    const nn::TimeSpan Interval = nn::TimeSpan::FromSeconds(5);

    const nn::TimeSpan PeriodTable[] = {
        nn::TimeSpan::FromMilliSeconds(1000),
        nn::TimeSpan::FromMilliSeconds(10),
    };

    const int DutyTable[] = {0, 25, 50, 75, 100};

    for (auto period : PeriodTable)
    {
        nn::pwm::SetPeriod(&session, period);
        ASSERT_EQ(nn::pwm::GetPeriod(&session), period);

        for (auto duty : DutyTable)
        {
            NN_LOG("Period: %d ms, Duty: %d %%\n", period.GetMilliSeconds(), duty);

            nn::pwm::SetDuty(&session, duty);

            nn::os::SleepThread(Interval);
        }
    }

    nn::pwm::CloseSession(&session);

    nn::pwm::Finalize();
}
