﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_TimeSpan.h>

//---------------------------------------------------------------------------
//  テスト用ヘルパー関数
//---------------------------------------------------------------------------

namespace nnt { namespace pwm {

// デフォルトでは 5 % 以下の誤差を合格としておく
// 供給クロックも含めて正確に調整できる必要があるテストケースでは通常より厳しい誤差でテストすべき
const int DefaultAllowableErrorPercent = 5;

// 二つの nn::TimeSpan 型の値の差が、expect を基準として± allowableErrorPercent [%] 以内かどうかを返します。
// allowableErrorPercent は 0-100 の値である必要があります。
bool IsTimeSpanNear(nn::TimeSpan expect, nn::TimeSpan actual, int allowableErrorPercent) NN_NOEXCEPT
{
    int64_t expectNsec = expect.GetNanoSeconds();
    int64_t actualNsec = actual.GetNanoSeconds();

    NN_ABORT_UNLESS(0 <= allowableErrorPercent && allowableErrorPercent <= 100);
    if (actualNsec < expectNsec * (100 - allowableErrorPercent) / 100)
    {
        return false;
    }
    else if (expectNsec * (100 + allowableErrorPercent) / 100 < actualNsec)
    {
        return false;
    }
    else
    {
        return true;
    }
}

}}
