﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include <nn/psm/psm.h>
#include <nn/psm/psm_Manufacture.h>

#include <nnt/nntest.h>

// ptm がファームウェアに含まれる場合、実行途中に停止（psm:manu ポートの無限待ち）が期待する挙動です。
// ptm.manu がファームウェアに含まれる場合、PASS が期待する挙動です。

TEST(PsmManufactureBasicTest, EnableSupplyRouteControl)
{
    ::nn::psm::Initialize();

    ::nn::psm::EnableSupplyRouteControl();

    ::nn::psm::Finalize();
}

TEST(PsmManufactureBasicTest, DisableSupplyRouteControl)
{
    ::nn::psm::Initialize();

    ::nn::psm::DisableSupplyRouteControl();

    ::nn::psm::Finalize();
}

TEST(PsmManufactureBasicTest, SetSupplyRoute)
{
    ::nn::psm::Initialize();

    ::nn::psm::SetSupplyRoute(::nn::psm::SupplyRoute_None);

    ::nn::psm::SetSupplyRoute(::nn::psm::SupplyRoute_Vdd50A);

    ::nn::psm::SetSupplyRoute(::nn::psm::SupplyRoute_Vdd50B);

    ::nn::psm::Finalize();
}
