﻿[string]$logNameStart = "NintendoCPUProfilerLog"
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition

. "$scriptPath/testProfiler_Common.ps1"

write-output "Starting testProfiler_CheckForCrashes"

function MoveFilesToTemp($logFiles)
{
    $destination = $Env:TEMP + "/NintendoCpuProfiler/logs/"
    for ($i = 0; $i -lt $logFiles.Length; ++$i)
    {
        $file = $logFiles[$i]
        write-output $file.Name
        move-item -Path $file.FullName -Destination $destination
    }
}

function CheckForCrashes()
{
    [Boolean]$hasError = $false

    $tempFolder = [System.IO.Path]::GetTempPath()
    $cd = [Environment]::CurrentDirectory
    $appData = [Environment]::GetFolderPath([Environment+SpecialFolder]::ApplicationData)

    $cdtemp = "$tempFolder/NintendoCpuProfiler/logs/"
    $cdcl = $cd
    $cdad = "$appData/Nintendo/Nintendo.CPU.Profiler/"

    [string]$filter = $logNameStart + "*.txt"

    $checkLoc = $cdtemp
    [Object[]]$logFiles = get-childitem "$checkLoc" -Filter $filter
    if ($logFiles.Length -gt 0)
    {
        WriteError "Crash log files found in $checkLoc"
        $hasError = $true
    }

    $checkLoc = $cdcl
    [Object[]]$logFiles = get-childitem "$checkLoc" -Filter $filter
    if ($logFiles.Length -gt 0)
    {
        WriteError "Crash log files found in $checkLoc"
        $hasError = $true
        MoveFilesToTemp $logFiles
    }

    $checkLoc = $cdad
    [Object[]]$logFiles = get-childitem "$checkLoc" -Filter $filter
    if ($logFiles.Length -gt 0)
    {
        WriteError "Crash log files found in $checkLoc"
        $hasError = $true
        MoveFilesToTemp $logFiles
    }

    return $hasError
}

RunTest("CheckForCrashes")

TestsFinished
