﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/srepo.h>
#include <nn/srepo/detail/srepo_SystemReportGenerator.h>

#include <nn/prepo.h>
#include <nn/prepo/detail/service/core/prepo_SystemReport.h>

#include "../Common/testPrepo_Common.h"

TEST(SystemReportTest, Main)
{
    nn::Bit8 buffer[nn::srepo::ReportBufferSizeMax];
    size_t position;
    auto Add = [&](const char* key, auto value) -> nn::Result
    {
        return nn::srepo::detail::SystemReportGenerator::AddKeyValue(
            &position, key, value, buffer, sizeof (buffer), position);
    };
    auto AddBinary = [&](const char* key, const void* value, size_t size) -> nn::Result
    {
        return nn::srepo::detail::SystemReportGenerator::AddKeyValue(
            &position, key, value, size, buffer, sizeof (buffer), position);
    };

    nn::Bit8 binaryBuffer[nn::srepo::BinaryValueSizeMax];

    for (size_t binarySize = 0; binarySize <= nn::srepo::BinaryValueSizeMax; binarySize++)
    {
        nn::os::GenerateRandomBytes(binaryBuffer, binarySize);

        nn::srepo::detail::SystemReportGenerator::Initialize(&position, buffer, sizeof(buffer));

        NNT_ASSERT_RESULT_SUCCESS(AddBinary("x", binaryBuffer, binarySize));
        NNT_ASSERT_RESULT_SUCCESS(Add("y", 4.56));
        NNT_ASSERT_RESULT_SUCCESS(Add("z", 7.89));

        nnt::prepo::MessagePackVerifier verifier(buffer, position);

        ASSERT_TRUE(verifier.VerifyMap(3u));
        ASSERT_TRUE(verifier.VerifyString("x"));
        ASSERT_TRUE(verifier.VerifyBinary(binaryBuffer, binarySize));
        ASSERT_TRUE(verifier.VerifyString("y"));
        ASSERT_TRUE(verifier.VerifyDouble(4.56));
        ASSERT_TRUE(verifier.VerifyString("z"));
        ASSERT_TRUE(verifier.VerifyDouble(7.89));

        ASSERT_TRUE(verifier.IsEnd());
    }

    for (size_t binarySize = 0; binarySize <= nn::srepo::BinaryValueSizeMax; binarySize++)
    {
        nn::os::GenerateRandomBytes(binaryBuffer, binarySize);

        nn::srepo::detail::SystemReportGenerator::Initialize(&position, buffer, sizeof(buffer));

        NNT_ASSERT_RESULT_SUCCESS(Add("x", 1.23));
        NNT_ASSERT_RESULT_SUCCESS(AddBinary("y", binaryBuffer, binarySize));
        NNT_ASSERT_RESULT_SUCCESS(Add("z", 7.89));

        nnt::prepo::MessagePackVerifier verifier(buffer, position);

        ASSERT_TRUE(verifier.VerifyMap(3u));
        ASSERT_TRUE(verifier.VerifyString("x"));
        ASSERT_TRUE(verifier.VerifyDouble(1.23));
        ASSERT_TRUE(verifier.VerifyString("y"));
        ASSERT_TRUE(verifier.VerifyBinary(binaryBuffer, binarySize));
        ASSERT_TRUE(verifier.VerifyString("z"));
        ASSERT_TRUE(verifier.VerifyDouble(7.89));

        ASSERT_TRUE(verifier.IsEnd());
    }

    for (size_t binarySize = 0; binarySize <= nn::srepo::BinaryValueSizeMax; binarySize++)
    {
        nn::os::GenerateRandomBytes(binaryBuffer, binarySize);

        nn::srepo::detail::SystemReportGenerator::Initialize(&position, buffer, sizeof(buffer));

        NNT_ASSERT_RESULT_SUCCESS(Add("x", 1.23));
        NNT_ASSERT_RESULT_SUCCESS(Add("y", 4.56));
        NNT_ASSERT_RESULT_SUCCESS(AddBinary("z", binaryBuffer, binarySize));

        nnt::prepo::MessagePackVerifier verifier(buffer, position);

        ASSERT_TRUE(verifier.VerifyMap(3u));
        ASSERT_TRUE(verifier.VerifyString("x"));
        ASSERT_TRUE(verifier.VerifyDouble(1.23));
        ASSERT_TRUE(verifier.VerifyString("y"));
        ASSERT_TRUE(verifier.VerifyDouble(4.56));
        ASSERT_TRUE(verifier.VerifyString("z"));
        ASSERT_TRUE(verifier.VerifyBinary(binaryBuffer, binarySize));

        ASSERT_TRUE(verifier.IsEnd());
    }
}
