﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/prepo.h>
#include <nn/prepo/prepo_Result.h>
#include <nn/prepo/detail/msgpack/prepo_MessagePack.h>

TEST(MessagePack, Write)
{
    nn::Bit8 buffer[1024] = {};
    nn::prepo::detail::msgpack::OutputStreamParam stream = {buffer, sizeof (buffer)};

    nn::prepo::detail::msgpack::WriteNil(&stream);
    EXPECT_EQ(nn::prepo::detail::msgpack::DataType_Nil, stream.buffer[0]);
    EXPECT_EQ(1, stream.position);
    stream.position = 0;

    nn::prepo::detail::msgpack::WriteBool(&stream, true);
    EXPECT_EQ(nn::prepo::detail::msgpack::DataType_True, stream.buffer[0]);
    EXPECT_EQ(1, stream.position);
    stream.position = 0;

    nn::prepo::detail::msgpack::WriteBool(&stream, false);
    EXPECT_EQ(nn::prepo::detail::msgpack::DataType_False, stream.buffer[0]);
    EXPECT_EQ(1, stream.position);
    stream.position = 0;
}

TEST(MessagePack, Read)
{
    nn::prepo::PlayReport report("event");
    nn::Bit8 buffer[1024];

    report.SetBuffer(buffer, sizeof (buffer));

    NNT_EXPECT_RESULT_SUCCESS(report.Add("position:x1", 1.23));
    NNT_EXPECT_RESULT_SUCCESS(report.Add("position:y1", 0.00));
    NNT_EXPECT_RESULT_SUCCESS(report.Add("position:z1", -5.55));
    NNT_EXPECT_RESULT_SUCCESS(report.Add("position:x2", 1.23));
    NNT_EXPECT_RESULT_SUCCESS(report.Add("position:y2", 0.00));
    NNT_EXPECT_RESULT_SUCCESS(report.Add("position:z2", -5.55));

    const size_t dataSize = nn::prepo::PlayReport::BufferSizeMin + ((sizeof ("position:xn") - 1) + 1 + 8 + 1) * 6;

    nn::prepo::detail::msgpack::InputStreamParam stream = {buffer, dataSize};
    nn::prepo::detail::msgpack::AnyData any = {};

    while (stream.position != dataSize)
    {
        bool result = nn::prepo::detail::msgpack::ReadCurrent(&any, &stream);

        EXPECT_TRUE(result);

        if (!result)
        {
            break;
        }
    }
}
